<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Conversation;
use Datatables;

class ConversationController extends Controller
{
    public function datatables()
    {
        
        $datas = Conversation::where('register_id',0)->get();

        return Datatables::of($datas)

        ->addColumn('sender', function(Conversation $data) {
            $name = $data->sent->first_name  . $data->sent->last_name;
            return $name;
        })
        ->addColumn('reciver', function(Conversation $data) {
            $name = $data->recieved->first_name . $data->recieved->last_name;
            return $name;
        })
        ->editColumn('created_at', function(Conversation $data) {
            $date = $data->created_at->diffForHumans();
            return $date;
        })
        ->addColumn('action', function(Conversation $data) {
            return '<div class="actions-btn"><a href="' . route('admin-conversation-details',$data->id) . '" class="btn btn-primary btn-sm btn-rounded">
            <i class="fas fa-eye"></i> '.__("Details").'
          </a><button type="button" data-toggle="modal" data-target="#deleteModal"  data-href="' . route('admin-conversation-delete',$data->id) . '" class="btn btn-danger btn-sm btn-rounded">
            <i class="fas fa-trash"></i>
          </button></div>';
        })
        ->rawColumns(['action','sender','reciver','created_at'])
        ->toJson(); 

    }


    public function index()
    {
        return view('admin.conversation.index');
    }

  public function details($id)
    {
        $conv = Conversation::findOrfail($id);
        return view('admin.conversation.details',compact('conv'));
    }

  public function delete($id)
    {
            $conv = Conversation::findOrfail($id);
            if($conv->messages->count() > 0)
            {
                foreach ($conv->messages as $key) {
                    $key->delete();
                }
            }
            $conv->delete();
            $mgs = __('Message Deleted Successfully');
            return response()->json($mgs);
    }
}
