<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Datatables;
use App\Models\EnrolledCourse;
use App\Models\User;
use App\Models\Course;
use App\Models\Admin;
use App\Models\Generalsetting;
use Carbon\Carbon;
use DB;
use Validator;

class EnrollmentHistoryController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:admin');
    }

        //*** JSON Request
        public function datatables()
        {

             $courses = Course::where('register_id',0)->pluck('id');

             $datas = EnrolledCourse::whereIn('course_id',$courses)->orderBy('id','desc')->get();
             //--- Integrating This Collection Into Datatables
             return Datatables::of($datas)
                                ->editColumn('user_id', function(EnrolledCourse $data) {
                                   $user = User::findOrFail($data->user_id);
                                   $user_name = $user->first_name.' '.$user->last_name;
                                   return $user_name;
                                })
                                ->editColumn('course_id', function(EnrolledCourse $data) {
                                    $course = Course::findOrFail($data->course_id);
                                    $course_name = $course->title;
                                    return $course_name;
                                 })
                                 ->editColumn('created_at', function(EnrolledCourse $data) {
                                    $created_at = Carbon::parse($data->created_at)->format('M d Y');
                                    return $created_at;
                                 })

                                 ->addColumn('certificate', function(EnrolledCourse $data) {
                                    $status      = $data->certificate == 1 ? __('Activated') : __('Deactivated');
                                    $status_sign = $data->certificate == 1 ? 'success'   : 'danger';
    
                                    return '<div class="btn-group mb-1">
                                    <button type="button" class="btn btn-'.$status_sign.' btn-sm btn-rounded dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                      '.$status .'
                                    </button>
                                    <div class="dropdown-menu" x-placement="bottom-start">
                                      <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="'. route('admin-enroll-cert',['id1' => $data->id, 'id2' => 1]).'">'.__("Activate").'</a>
                                      <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="'. route('admin-enroll-cert',['id1' => $data->id, 'id2' => 0]).'">'.__("Deactivate").'</a>
                                    </div>
                                  </div>';
                                })

                                ->addColumn('action', function(EnrolledCourse $data) {
                                    $certificate = $data->certificate == 1 ? '<a target="_blank" href="'.route('admin-enroll-cert-show',$data->id).'" class="btn btn-primary btn-sm btn-rounded"><i class="fas fa-eye"></i></a>' : '';
                                    return '<div class="actions-btn">'.$certificate.'<button type="button" data-toggle="modal" data-target="#deleteModal"  data-href="' . route('admin-enroll-history-delete',$data->id) . '" class="btn btn-danger btn-sm btn-rounded">
                                    <i class="fas fa-trash"></i>
                                  </button></div>';
                                })
                                ->rawColumns(['user_id','course_id','created_at','certificate','action'])
                                ->toJson(); //--- Returning Json Data To Client Side
        }

        //*** GET Request
        public function index()
        {
            return view('admin.enrollment.index');
        }

        //*** GET Request Status
        public function certificate($id1,$id2)
        {
            $data = EnrolledCourse::findOrFail($id1);
            $data->certificate = $id2;
            $data->update();

            //--- Redirect Section
            $msg = __('Status Updated Successfully.');
            return response()->json($msg);
            //--- Redirect Section Ends

        }


      //*** GET Request Status
      public function certificate_show($id)
      {
        $gs = Generalsetting::find(1);
        $data = EnrolledCourse::findOrFail($id);
        $admin = Admin::first()->name;

        $student = $data->user->showName();
        $course = $data->course->title;
        $body = preg_replace("/{student_name}/", $student  ,$gs->cert_text);
        $body = preg_replace("/{admin_name}/", $admin ,$body);
        $body = preg_replace("/{course_title}/", $course  ,$body);
        $body = preg_replace("/{website_title}/", $gs->title ,$body);

        //--- Redirect Section
  
        return view('admin.enrollment.certificate',compact('body','student','course','data'));
        //--- Redirect Section Ends

      }

        //*** GET Request Delete
        public function destroy($id)
        {
            $data = EnrolledCourse::findOrFail($id);
            $data->delete();
            //--- Redirect Section
            $msg = 'Data Deleted Successfully.';
            return response()->json($msg);
            //--- Redirect Section Ends
        }
}
