<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Conversation extends Model
{

	public function sent()
	{
	    return $this->belongsTo('App\Models\User', 'sent_user')->withDefault();
	}

	public function recieved()
	{
	    return $this->belongsTo('App\Models\User', 'recieved_user')->withDefault();
	}

	public function messages()
	{
	    return $this->hasMany('App\Models\Message');
	}

	public function owner(){
		return $this->belongsTo('App\Models\Admin','register_id')->withDefault();
	}

}
