<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EnrolledCourse extends Model
{
    protected $fillable = ['course_id','user_id','register_id','preloaded'];

    public $timestamps = false;

    public function user()
    {
    	return $this->belongsTo('App\Models\User')->withDefault();
    }

    public function course()
    {
    	return $this->belongsTo('App\Models\Course')->withDefault();
	}
	
	public function owner(){
		return $this->belongsTo('App\Models\Admin','register_id')->withDefault();
	}

}
