<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReferralHistory extends Model
{
    protected $fillable = ['register_id', 'referrer_id', 'affilate_id', 'course_id', 'type','register_id','preloaded'];
    public $timestamps = false;

    public function referrer()
    {
    	return $this->belongsTo('App\Models\User','referrer_id')->withDefault();
    }


    public function affilate()
    {
    	return $this->belongsTo('App\Models\User','affilate_id')->withDefault();
    }


    public function course()
    {
    	return $this->belongsTo('App\Models\Course','course_id')->withDefault();
	}
	
	public function owner(){
		return $this->belongsTo('App\Models\Admin','register_id')->withDefault();
	}

	public function user(){
		return $this->belongsTo('App\Models\User');
	}

}
