<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subcategory extends Model
{
    protected $fillable = ['category_id','name','slug','register_id','preloaded'];
    public $timestamps = false;

    public function category()
    {
    	return $this->belongsTo('App\Models\Category')->withDefault();
	}
	
	public function courses()
    {
        return $this->hasMany('App\Models\Course');
    }

    public function setSlugAttribute($value)
    {
        $this->attributes['slug'] = str_replace(' ', '-', $value);
    }

    public function owner(){
		return $this->belongsTo('App\Models\Admin','register_id')->withDefault();
	}


}
