<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserSubscription extends Model
{
   protected $fillable = ['user_id', 'subscription_id', 'title', 'currency', 'currency_code', 'price', 'days', 'allowed_products', 'details', 'method', 'txnid', 'charge_id', 'created_at', 'updated_at', 'status','register_id','preloaded'];

    public function user()
    {
        return $this->belongsTo('App\Models\User')->withDefault();
    }

    public function owner(){
      return $this->belongsTo('App\Models\Admin','register_id')->withDefault();
    }
}
