@extends('layouts.admin')
@section('styles')
 <link href="{{ asset('assets/admin/css/instructor.css') }}" rel="stylesheet">
@endsection
@section('content')

<div class="content-area">

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Conversation Details') }} <a class="btn btn-primary btn-rounded btn-sm" href="{{route('admin-conversation-index')}}"><i class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="javascript:;">{{ __('Conversation Details') }}</a></li>
        </ol>
        </div>
    </div>

    <div class="order-table-wrap support-ticket-wrapper ">
        <div class="panel panel-primary">
        <div class="gocover" style="background: url({{asset('assets/images/'.$gs->admin_loader)}}) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
        @include('includes.admin.form-both')
            <div class="panel-body" id="messages">

                @foreach($conv->messages as $message)
                @if($message->sent_user != null)

                <div class="single-reply-area admin">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="reply-area">
                                <div class="left">
                                    @if($message->conversation->sent->is_provider == 1 )
                                    <img class="img-circle" src="{{ $message->conversation->sent->photo != null ? $message->conversation->sent->photo : asset('assets/images/noimage.png') }}" alt="">
                                    @else
                                    <img class="img-circle" src="{{ $message->conversation->sent->photo != null ? asset('assets/images/users/'.$message->conversation->sent->photo) : asset('assets/images/noimage.png') }}" alt="">
                                    @endif
                                    <p class="ticket-date">{{ $message->conversation->sent->first_name . $message->conversation->sent->last_name }}</p>
                                </div>
                                <div class="right">
                                    <p>{{ $message->message }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <br>
                @else

                <div class="single-reply-area user">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="reply-area">
                                <div class="left">
                                    <p>{{ $message->message }}</p>
                                </div>
                                <div class="right">
                                    @if($message->conversation->recieved->is_provider == 1 )
                                    <img class="img-circle" src="{{ $message->conversation->recieved->photo != null ? $message->conversation->recieved->photo : asset('assets/images/noimage.png') }}" alt="">
                                    @else
                                    <img class="img-circle" src="{{ $message->conversation->recieved->photo != null ? asset('assets/images/users/'.$message->conversation->recieved->photo) : asset('assets/images/noimage.png') }}" alt="">
                                    @endif
                                    <p class="ticket-date">{{$message->conversation->recieved->first_name . $message->conversation->recieved->last_name}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                @endif
                @endforeach
            </div>
        </div>
    </div>

@endsection


