@extends('layouts.admin') 

@section('content')  
<div class="content-area">
	<div class="card">
	  <div class="d-sm-flex align-items-center justify-content-between">
	  <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Language Settings') }}</h5>
	  <ol class="breadcrumb">
		  <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
		  <li class="breadcrumb-item"><a href="javascript:;">{{ __('Language Settings') }}</a></li>
		  <li class="breadcrumb-item"><a href="{{ route('admin-lang-index') }}">{{ __('Website Language') }}</a></li>
	  </ol>
	  </div>
	</div>
  </div>

	<!-- Row -->
	<div class="row mt-3">
	<!-- Datatables -->
	<div class="col-lg-12">

		@include('includes.admin.form-success')

		<div class="card mb-4">
		<div class="table-responsive p-3">
			<table class="table align-items-center table-flush" id="geniustable">
			<thead class="thead-light">
				<tr>
					<th>{{ __('Language') }}</th>
					<th>{{ __('Options') }}</th>
				</tr>
			</thead>
			</table>
		</div>
		</div>
	</div>
	<!-- DataTable with Hover -->
	</div>
	<!--Row-->

{{-- DELETE MODAL --}}
<div class="modal fade confirm-modal" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">{{ __("Confirm Delete") }}</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<p class="text-center">{{__("You are about to delete this Language. Every informtation under this Language will be deleted.")}}</p>
				<p class="text-center">{{ __("Do you want to proceed?") }}</p>
			</div>
			<div class="modal-footer">
				<a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __("Cancel") }}</a>
				<a href="javascript:;" class="btn btn-danger btn-ok">{{ __("Delete") }}</a>
			</div>
		</div>
	</div>
</div>

{{-- DELETE MODAL ENDS --}}


@endsection    



@section('scripts')

    <script type="text/javascript">

		var table = $('#geniustable').DataTable({
			   ordering: false,
               processing: true,
               serverSide: true,
               ajax: '{{ route('admin-lang-datatables') }}',
               columns: [
                        { data: 'language', name: 'language' },
            			{ data: 'action', searchable: false, orderable: false }

                     ],
               language: {
                	processing: '<img src="{{asset('assets/images/'.$gs->admin_loader)}}">'
                }
            });

	   $(function() {
            $(".btn-area").append('<div class="col-sm-12 col-md-4 pr-3 text-right">'+
                '<a class="btn btn-primary" href="{{route('admin-lang-create')}}">'+
            '<i class="fas fa-plus"></i> {{ __('Add New Language') }}'+
            '</a>'+
            '</div>');
        });											
									
    </script>
@endsection   