@extends('layouts.admin')

@section('content')
<div class="card">
  <div class="d-sm-flex align-items-center justify-content-between">
  <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Add New Subscription Package') }} <a class="btn btn-primary btn-rounded btn-sm" href="{{route('admin-spackage-index')}}"><i class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
  <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
      <li class="breadcrumb-item"><a href="javascript:;">{{ __('Manage License') }}</a></li>
      <li class="breadcrumb-item"><a href="{{route('admin-spackage-index')}}">{{ __('Subscription Package') }}</a></li>
      <li class="breadcrumb-item"><a href="{{route('admin-spackage-create')}}">{{ __('Add New Subscription Package') }}</a></li>
  </ol>
  </div>
</div>

<div class="row justify-content-center mt-3">
<div class="col-lg-6">
  <!-- Form Basic -->
  <div class="card mb-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
      <h6 class="m-0 font-weight-bold text-primary">{{ __('Add New Subscription Package Form') }}</h6>
    </div>

    <div class="card-body">
      <div class="gocover" style="background: url({{asset('assets/images/'.$gs->admin_loader)}}) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
      <form class="geniusform" action="{{route('admin-spackage-create')}}" method="POST" enctype="multipart/form-data">

          @include('includes.admin.form-both')

          {{ csrf_field() }}

          <div class="form-group">
            <label for="title">{{ __('Title') }}</label>
            <input type="text" class="form-control" id="title" name="title"  placeholder="{{ __('Enter Title') }}" value="" required>
          </div>


        <div class="form-group">
          <label for="limited_course">{{ __('Limited Courses') }} <small>({{__('Set 0 to make it unlimited.')}})</small></label>
          <input type="number" class="form-control" min="0" id="limited_course" name="limited_course"  placeholder="{{ __('Enter Limited Courses') }}" value="" required>
        </div>

        <div class="form-group">
          <label for="limited_student">{{ __('Limited Students') }} <small>({{__('Set 0 to make it unlimited.')}})</small></label>
          <input type="number" class="form-control" min="0" id="limited_student" name="limited_student"  placeholder="{{ __('Enter Limited Students') }}" value="" required>
        </div>

        <div class="form-group">
          <label for="limited_teacher">{{ __('Limited Teachers') }} <small>({{__('Set 0 to make it unlimited.')}})</small></label>
          <input type="number" class="form-control" min="0" id="limited_teacher" name="limited_teacher"  placeholder="{{ __('Enter Limited Teachers') }}" value="" required>
        </div>


        <div class="form-group">
          <label for="teacher_course">{{ __('Courses Per Teacher') }} <small>({{__('Set 0 to make it unlimited.')}})</small></label>
          <input type="number" class="form-control" min="0" id="teacher_course" name="teacher_course"  placeholder="{{ __('Enter Courses Per Teacher') }}" value="" required>
        </div>

        <div class="form-group">
          <label for="wp_item_number">{{ __('W+ Item Number') }}</label>
          <input type="text" class="form-control" id="wp_item_number" name="wp_item_number"  placeholder="{{ __('Enter W+ Item Number') }}" value="">
        </div>


        <div class="form-group">
          <div class="custom-control custom-checkbox">
            <input type="checkbox" name="preloaded_contents" class="custom-control-input" id="preloaded_contents" value="1">
            <label class="custom-control-label" for="preloaded_contents"> {{__('Allow Preloaded Contents')}}</label>
          </div>
        </div>

        <div class="form-group">
          <div class="custom-control custom-checkbox">
            <input type="checkbox" name="notify_popup" class="custom-control-input" id="notify_popup" value="1">
            <label class="custom-control-label" for="notify_popup"> {{__('Allow Notification Pop Up')}}</label>
          </div>
        </div>

        <div class="form-group">
          <div class="custom-control custom-checkbox">
            <input type="checkbox" name="subs_popup" class="custom-control-input" id="subs_popup" value="1">
            <label class="custom-control-label" for="subs_popup"> {{__('Allow Subscription Pop Up')}}</label>
          </div>
        </div>


        <div class="form-group">
          <div class="custom-control custom-checkbox">
            <input type="checkbox" name="whitelevel" class="custom-control-input" id="whitelevel" value="1">
            <label class="custom-control-label" for="whitelevel"> {{__('Allow White Level Feature')}}</label>
          </div>
        </div>

        <div class="form-group">
          <div class="custom-control custom-checkbox">
            <input type="checkbox" name="future_update" class="custom-control-input" id="future_update" value="1">
            <label class="custom-control-label" for="future_update"> {{__('Allow Future Update')}}</label>
          </div>
        </div>

        <div class="form-group">
          <div class="custom-control custom-checkbox">
            <input type="checkbox" name="seo" class="custom-control-input" id="seo" value="1">
            <label class="custom-control-label" for="seo"> {{__('Allow Seo')}}</label>
          </div>
        </div>


          <button type="submit" id="submit-btn" class="btn btn-primary">{{ __('Submit') }}</button>

      </form>
    </div>
  </div>

  <!-- Form Sizing -->

  <!-- Horizontal Form -->

</div>

</div>
<!--Row-->


@endsection

@section('scripts')

<script>

$("#seo").change(function() {
    if(this.checked) {
        $('.showbox').removeClass('d-none');
    }else{
        $('.showbox').addClass('d-none');
    }
});

</script>

@endsection
