@extends('layouts.front')
@section('content')

<!--Main Breadcrumb Area Start -->
<div class="main-breadcrumb-area" style="background-image: url({{ $gs->breadcumb_banner ? asset('assets/images/'.$gs->breadcumb_banner):asset('assets/images/noimage.png') }});">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <ul class="pages">
          <li>
            <a href="{{route('front.index')}}">
              {{ __('Home') }}
            </a>
          </li>
          <li>
            <a href=" {{ route('front.blog') }} ">
              {{ __('Blog') }}
            </a>
          </li>
        </ul>
      </div>
    </div>
  </div>
</div>
<!--Main Breadcrumb Area End -->

  <!-- Blog Area Start -->
<section class="blog blog-details">
  <div class="container">
    <div class="row">
      <div class="col-lg-8">
        <div class="blog-box blog-details-box">
          <div class="blog-images">
              <div class="img">
                <img src="{{ asset('assets/images/blogs/'.$blog->photo) }}" class="img-fluid" alt="">
              </div>
              <div class="date d-flex justify-content-center">
                <div class="box align-self-center">
                  <p>{{ date('d',(strtotime($blog->created_at))) }}</p>
                  <p>{{ date('M',(strtotime($blog->created_at))) }}</p>
                </div>
              </div>
          </div>
          <div class="details">
              <a href='blog-details.html'>
                <h4 class="blog-title">
                  {{$blog->title}}
                </h4>
              </a>
              <ul class="post-meta">

                <li>
                  <a href="javascript:;">
                    <i class="fas fa-eye"></i>
                    {{__('Views')}} ({{$blog->views}})
                  </a>
                </li>
                <li>
                  <a href="javascript:;">
                    <i class="fas fa-link"></i>
                    {{__('Source')}} {{$blog->source}}
                  </a>
                </li>
              </ul>
            <div class="content">

              {!! $blog->details !!}

            </div>
          </div>
          <div class="social-link a2a_kit a2a_kit_size_32">
            <ul class="social-links">
              <li>
                <a class="facebook a2a_button_facebook" href="">
                  <i class="fab fa-facebook-f"></i>
                </a>
              </li>
                <li>
                    <a class="twitter a2a_button_twitter" href="">
                      <i class="fab fa-twitter"></i>
                    </a>

                </li>
                <li>
                    <a class="linkedin a2a_button_linkedin" href="">
                      <i class="fab fa-linkedin-in"></i>
                    </a>

                </li>
                <li>

                <a class="a2a_dd plus" href="https://www.addtoany.com/share">
                    <i class="fas fa-plus"></i>
                  </a>
                </li>
            </ul>
          </div>
          <script async src="https://static.addtoany.com/menu/page.js"></script>
        </div>
        <div class="comment-area">
              {{-- DISQUS START --}}
          @if($gs->is_disqus == 1)
            <div class="comments">
                 {!! $gs->disqus !!}
            </div>
          @endif
          {{-- DISQUS ENDS --}}
        </div>
      </div>
      <div class="col-lg-4">
        <div class="blog-aside">
          <div class="serch-widget">
            <h4 class="title">
              {{ __('Search') }}
            </h4>
            <form action="{{route('front.blogsearch')}}" method="get">
              <input type="text" name="search" placeholder="{{__('Search Content')}}">
              <button class="submit" type="submit">{{__('Search')}}</button>
            </form>
          </div>
          <div class="categori">
            <h4 class="title">{{ __('Categories') }}</h4>
            <ul class="categori-list">
              @foreach ($bcat as $cat)
              <li>
                <a href="{{ route('front.blogcategory',[$cat->slug,$cat->id]) }}" {!! $cat->id == $blog->category_id ? 'class="active"':'' !!}>
                  <span>{{$cat->name}}</span>
                  <span>{{$cat->blogs->count()}}</span>
                </a>
              </li>
              @endforeach

            </ul>
          </div>
          <div class="recent-post-widget">
            <h4 class="title">{{ __('Recent Post') }}</h4>
            <ul class="post-list">
              @foreach (App\Models\Blog::orderBy('created_at', 'desc')->where('register_id',0)->limit(4)->get() as $blogg)
              <li>
                  <div class="post">
                      <div class="post-img">
                          <img style="width: 73px; height: 59px;" src="{{ asset('assets/images/blogs/'.$blogg->photo) }}" alt="blog-image">
                      </div>
                      <div class="post-details">
                          <a href="{{route('front.blogshow',$blogg->id)}}}">
                              <h4 class="post-title">
                                  {{strlen($blogg->title) > 45 ? substr($blogg->title,0,45)." .." : $blogg->title}}
                              </h4>
                          </a>
                          <p class="date">
                              {{ date('M d - Y',(strtotime($blogg->created_at))) }}
                          </p>
                      </div>
                  </div>
              </li>
              @endforeach
            </ul>
          </div>

          <div class="tags">
            <h4 class="title">{{__('Tags')}}</h4>
            <span class="separator"></span>
            <ul class="tags-list">
              @foreach($tags as $tag)
               @if(!empty($tag))
                      <li>
                          <a href="{{ route('front.blogtags',$tag) }}">{{ $tag }} </a>
                      </li>
                @endif
              @endforeach
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Blog Area End-->
@endsection