
<!DOCTYPE html>
<html lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="keywords" content="{{ $seo->meta_keys }}">
	<title>{{ $gs->title }}</title>

	<!-- favicon -->
	<link rel="shortcut icon" href="{{asset('assets/images/'.$gs->favicon)}}" type="image/x-icon">
	<!-- bootstrap -->
	<link rel="stylesheet" href="{{asset('assets/front/css/bootstrap.min.css')}}">
	<!-- Plugin css -->
    <link rel="stylesheet" href="{{asset('assets/front/css/plugin.css')}}">
    <!-- Toastr css -->
	<link rel="stylesheet" href="{{asset('assets/front/css/toastr.css')}}">
	<!-- stylesheet -->
	<link rel="stylesheet" href="{{asset('assets/front/css/style.css')}}">
	<!-- responsive -->
	@yield('styles')
	<link rel="stylesheet" href="{{asset('assets/front/css/responsive.css')}}">

	<link rel="stylesheet" id="color" href="{{ asset('assets/front/css/style.php?colors='.str_replace('#','', $gs->colors)) }}">


	@if(!empty($seo->google_analytics))
	<script>
		window.dataLayer = window.dataLayer || [];
		function gtag() {
				dataLayer.push(arguments);
		}
		gtag('js', new Date());
		gtag('config', '{{ $seo->google_analytics }}');
	</script>
	@endif


</head>

<body>

    @if($gs->is_loader == 1)
	<div class="preloader" id="preloader" style="background: url({{asset('assets/images/'.$gs->loader)}})"></div>
    @endif

	<!--Main-Menu Area Start-->
	<div class="mainmenu-area">
		<div class="container-fluid">
			<div class="row">
				<div class="col-lg-12">
					<nav class="my-navbar d-flex justify-content-center">
						<div >
							<a class="navbar-brand mt-5" href="{{route('front.index')}}">
								<img src="{{asset('assets/images/'.$gs->logo)}}" alt="logo">
							</a>

						</div>


					</nav>
				</div>
			</div>
		</div>
	</div>
	<!--Main-Menu Area Start-->


  <!-- Login Area Start -->
  <section class="new-login">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-7">
          <div class="new-login-box">

            <div class="right-content">
              <ul class="nav" id="pills-tab" role="tablist">

                <li class="nav-item register">
                  <a class="nav-link active" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab" aria-controls="pills-profile" aria-selected="true">
                    <i class="fas fa-user-plus"></i>{{__('REGISTER')}}
                  </a>
                </li>
              </ul>
              <div class="tab-content" id="pills-tabContent">

                <div class="tab-pane fade active show" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                  <div class="login-area">
                    <div class="login-form signup-form">

                      @include('includes.form-success')

                      @include('includes.form-error')

                      <form  action="{{ route('owner-secret-register',$package->unique_code) }}" method="POST" enctype="multipart/form-data">

                        @csrf
                        <div class="form-input mb-1">
                            <div class="form-group mb-0">
                            <label class="form-label" for="photo">{{ __('Photo *') }}</label>
                                <input type="file" id="photo" class="pl-0 form-control-file border-0"  name="photo" required>
                            </div>
                        </div>


                        <div class="form-input mb-3">
                          <div class="form-group mb-0">
                          <label class="form-label" for="username">{{ __('Username *') }} <small>({{url('/')}}/username)</small></label>
                          <input type="text" id="username" class="pl-3" placeholder="{{ __('Enter Username') }}"  name="username" value="{{ old('username') }}" required>
                          </div>
                       </div>


                        <div class="form-input">
                        <input type="text" class="pl-3" placeholder="{{__('Name')}}" name="name" value="{{ old('name') }}" required>
                        </div>
                        <div class="form-input">
                          <input type="email" class="pl-3" placeholder="{{__('Enter Email Address')}}" name="email" value="{{ old('email') }}" required>
                        </div>
                        <div class="form-input">
                            <input type="text" class="pl-3" placeholder="{{__('Phone Number')}}" name="phone" value="{{ old('phone') }}" required>
                        </div>

                        <div class="form-input">
                          <input type="password" class="pl-3" class="Password" name="password" placeholder="{{__('Password')}}" required>
                        </div>
                        <div class="form-input">
                            <textarea name="biography" class="pl-3 pt-2 form-control" placeholder="{{__('Enter Biography')}}" cols="30" rows="5" required>{{ old('biography') }}</textarea>
                        </div>
                        <div class="form-input">
                            <input type="text" class="pl-3"  name="address" placeholder="{{__('Enter Address')}}" value="{{ old('address') }}" required>
                         </div>

      

                        <button class="submit-btn">{{ __('Register') }}</button>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Login Area End -->

	<!-- Back to Top Start -->
	<div class="bottomtotop">
		<i class="fas fa-chevron-right"></i>
	</div>
	<!-- Back to Top End -->



	<!-- Become an instructor modal End -->
	<script>

       	var capchaurl = "{{ url('/') }}";

        var mainurl = "{{ url('/') }}";

        var gs      = {!! json_encode(DB::table('generalsettings')->where('id','=',1)->first(['is_loader'])) !!};

        var langg = {
            'cart_already'   : '{{ __('Already Added To Cart.') }}',
			'add_cart'       : '{{ __('Successfully Added To Cart.') }}',
            'add_wish'   	 : '{{ __('Successfully Added To Wishlist.') }}',
			'already_wish'   : '{{ __('Already Added To Wishlist.') }}',
			'wish_remove'    : '{{ __('Successfully Removed From Wishlist.') }}',
            'cart_empty'     : '{{ __('Cart is empty.') }}',
            'authenticating' : '{{ __('Authenticating') }}',
            'processing'     : '{{ __('Processing') }}',
            'checking'       : '{{ __('Checking') }}',
            'affiliate_link_copy': '{{ __('Affiliate Link Copied Successfully') }}'

        };

	</script>

	<!-- jquery -->
	<script src="{{asset('assets/front/js/jquery.js')}}"></script>
	<!-- popper -->
    <script src="{{asset('assets/front/js/popper.min.js')}}"></script>
	<!-- bootstrap -->
	<script src="{{asset('assets/front/js/bootstrap.min.js')}}"></script>
    <!-- plugin js-->
	<script src="{{asset('assets/front/js/plugin.js')}}"></script>
	{{-- toastr.js --}}
	<script src="{{asset('assets/front/js/toastr.js')}}"></script>
	<!-- custom js-->
	<script src="{{asset('assets/front/js/custom.js')}}"></script>
	<!-- main -->
	<script src="{{asset('assets/front/js/main.js')}}"></script>

<script>

$('#username').on('input', function(){
    var company_name = $('#username').val().replace(/[^A-Z0-9]/ig, "");
    $('#username').val(company_name);
  });

</script>

</body>

</html>
