@extends('layouts.instructor')
@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Change Password') }}</h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('instructor-dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="{{ route('instructor-reset') }}">{{ __('Change Password') }}</a></li>
        </ol>
        </div>
    </div>

    <div class="row justify-content-center mt-3">
      <div class="col-lg-6">
        <!-- Form Basic -->
        <div class="card mb-4">
          <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Change Password Form') }}</h6>
          </div>

          <div class="card-body">
            <div class="gocover" style="background: url({{asset('assets/images/'.$gs->admin_loader)}}) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
            <form class="geniusform" action="{{ route('instructor-reset-submit') }}" method="POST" enctype="multipart/form-data">

                @include('includes.admin.form-both')

                {{ csrf_field() }}

                <div class="form-group">
                    <label for="inp-cpass">{{ __('Current Password') }}</label>
                    <input type="password" class="form-control" id="inp-cpass" name="cpass"  placeholder="{{ __('Enter Current Password') }}" value="" required>
                </div>

                <div class="form-group">
                    <label for="inp-newpass">{{ __('New Password') }}</label>
                    <input type="password" class="form-control" id="inp-newpass" name="newpass"  placeholder="{{ __('Enter New Password') }}" value="" required>
                </div>

                <div class="form-group">
                    <label for="inp-renewpass">{{ __('Re-Type New Password') }}</label>
                    <input type="password" class="form-control" id="inp-renewpass" name="renewpass"  placeholder="{{ __('Re-Type New Password') }}" value="" required>
                </div>

                <button type="submit" id="submit-btn" class="btn btn-primary">{{ __('Submit') }}</button>

            </form>
          </div>
        </div>

        <!-- Form Sizing -->


        <!-- Horizontal Form -->

      </div>


    </div>
    <!--Row-->


@endsection
