

<div class="modal fade" id="lessonModalAdd" tabindex="-1" role="dialog" aria-labelledby="lessonModalAddTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title"><?php echo e(__("Add New Lesson")); ?></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <div class="modal-body ml-2 mr-2">

                <form class="c-form" action="<?php echo e(route('instructor-lesson-store')); ?>" method="POST" enctype="multipart/form-data">

                    <?php echo $__env->make('includes.admin.form-both', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php echo e(csrf_field()); ?>


                    <div class="form-group">
                        <label for="section_id"><?php echo e(__('Section')); ?> *</label>
                        <select class="form-control" name="section_id" id="section_id" required>
                            <?php $__currentLoopData = $data->sections()->oldest('id')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($section->id); ?>"><?php echo e($section->title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="title"><?php echo e(__('Title')); ?> *</label>
                        <input class="form-control" type="text" name="title"  id="title" required="" placeholder="<?php echo e(__('Enter Title')); ?>">
                    </div>

                    <div class="form-group">
                        <label for="video_file"><?php echo e(__('Type')); ?> *</label>
                        <select class="form-control video_file" name="video_file" id="video_file" required>
                                <option value="youtube"><?php echo e(__('YouTube')); ?></option>
                                <option value="vimeo"><?php echo e(__('Vimeo')); ?></option>
                                <option value="file"><?php echo e(__('File')); ?></option>
                                <option value="url"><?php echo e(__('Link')); ?></option>
                                <option value="document"><?php echo e(__('Document')); ?></option>
                                <option value="image"><?php echo e(__('Image')); ?></option>
                                <option value="iframe"><?php echo e(__('Iframe')); ?></option>
                        </select>
                    </div>

                    <div class="file_show">

                        <?php if($gs->is_youtube_api == 1): ?>

                        <div class="form-group">
                            <label for="link"><?php echo e(__("Search Video")); ?> *</label>
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="<?php echo e(__("Search Youtube Video")); ?>" class="ysearch" autocomplete="off">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-secondary btn-sm pull-right ysearch-btn">
                                        <i class="fa fa-check"></i>
                                    </button>
                                </div>
                            </div>

                            <div class="autocomplete">
                                <div id="myInputautocomplete-list" class="autocomplete-items"></div>
                            </div>

                        </div>

                        <?php endif; ?>

                        <div class="form-group">
                            <label for="link"><?php echo e(__("Link")); ?> *</label>
                            <input class="form-control" type="text" name="url"  id="link"  placeholder="<?php echo e(__("Enter Youtube Video Link")); ?>">
                        </div>

                        <div class="form-group">
                            <label for="duration"><?php echo e(__("Duration")); ?> *</label>
                            <input type="text" class="form-control"  name="duration" id="duration" value="00:00:00" required="">
                        </div>

                    </div>

                    <div class="form-group">
                        <label for="details"><?php echo e(__('Details')); ?> *</label>
                        <textarea class="form-control" name="details" id="details" placeholder="<?php echo e(__('Enter Details')); ?>" required></textarea>
                    </div>

                    <input type="hidden" name="type" value="Lesson">

                    <div class="text-right">
                        <button class="btn btn-success submit-btn" type="submit"><?php echo e(__('Submit')); ?></button>
                    </div>
                </form>

            </div>
            <div class="modal-footer">
            <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__("Close")); ?></a>
            </div>
        </div>
    </div>
</div>


<?php /**PATH /home/royaldem/public_html/project/resources/views/instructor/course/includes/lesson/lesson_add.blade.php ENDPATH**/ ?>