<?php $__env->startSection('content'); ?>

<!-- User Dashboard Area Start -->
<section class="user-dashboard">
    <div class="user-dashboard-menu-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h4 class="heading-title">
                        <?php echo e(__('My Wishlists')); ?>

                    </h4>
                    <?php echo $__env->make('student.includes.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="user-dashboard-content-area">
        <div class="container" id="ajaxContent">

            <div class="row all-videos wishlists">

                <?php $__currentLoopData = $wishlists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-lg-4 col-md-6">
                    <div class="single-course">
                        <div class="img">
                            <img src="<?php echo e(asset('assets/images/courses/'.$course->photo)); ?>" alt="course">
                            <a href="javascript:;" class="remove wishlist-remove" data-href="<?php echo e(route('student-wishlist-remove', App\Models\Wishlist::where('user_id','=',$user->id)->where('course_id','=',$course->id)->first()->id )); ?>">
                                <i class="fas fa-times"></i>
                            </a>
                        </div>
                        <div class="content">
                            <p class="author">
                                <a href="<?php echo e(!empty($course->instructor) ? route('instructor.details',$course->instructor->instructor_slug) : route('instructor.details',DB::table('admins')->first()->slug)); ?>">
                                    <?php echo e(!empty($course->instructor) ? $course->instructor->instructor_name : DB::table('admins')->first()->name); ?>

                                  </a>
                            </p>
                            <a href="<?php echo e(route('front.course',$course->slug)); ?>">
                                <h4 class="title">
                                    <?php echo e($course->showTitle()); ?>

                                </h4>
                            </a>

                            <div class="reating-area">
                              <span class="number"><?php echo e(App\Models\Rating::normalRating($course->id)); ?></span>
                              <div class="stars">
                                  <div class="ratings">
                                      <div class="empty-stars"></div>
                                      <div class="full-stars" style="width:<?php echo e(App\Models\Rating::ratings($course->id)); ?>%"></div>
                                    </div>
                              </div>
                              <div class="total-star">
                                (<?php echo e(App\Models\Rating::ratingCount($course->id)); ?>)
                              </div>
                            </div>

                            <p class="price">
                                <?php echo e($curr->sign); ?><?php echo e(round(($course->price * $curr->value),2)); ?> <del><?php echo e($curr->sign); ?><?php echo e(round(($course->discount_price * $curr->value),2)); ?></del>
                            </p>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

            <div class="page-center mt-5">
                <?php echo $wishlists->links(); ?>

            </div>

        </div>
    </div>

</section>
<!-- User Dashboard Area End -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/student/wishlist.blade.php ENDPATH**/ ?>