<?php if(Session::has('cart')): ?>

<div class="dropdownmenu-wrapper">
    <div class="dropdown-cart-header">
        <span class="item-no">
            <span class="cart-quantity">
                <?php echo e(Session::has('cart') ? count(Session::get('cart')->items) : '0'); ?>

            </span> <?php echo e(__('Item(s)')); ?>

        </span>

        <a class="view-cart" href="<?php echo e(route('front.cart')); ?>">
            <?php echo e(__('View Cart')); ?>

        </a>
    </div>
    <ul class="dropdown-cart-products">

        <?php $__currentLoopData = Session::get('cart')->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>



            <li class="product cremove<?php echo e($course['item']['id']); ?>">
                <div class="product-details">
                    <div class="content">
                        <a href="<?php echo e(route('front.course',$course['item']['slug'])); ?>">
                            <h4 class="product-title">
                                <?php echo e(mb_strlen($course['item']['title'],'UTF-8') > 55 ? mb_substr($course['item']['title'],0,55,'UTF-8').'...' : $course['item']['title']); ?>

                            </h4>
                        </a>

                        <span class="cart-product-info">
                            <span id="prct<?php echo e($course['item']['id']); ?>"><?php echo e($curr->sign); ?><?php echo e(round(($course['price'] * $curr->value),2)); ?></span>
                        </span>
                    </div>
                </div>

                <figure class="product-image-container">
                    <a href="<?php echo e(route('front.course', $course['item']['slug'])); ?>" class="product-image">
                        <img src="<?php echo e(asset('assets/images/courses/'.$course['item']['photo'])); ?>" alt="product">
                    </a>
                    <div class="cart-remove" data-class="cremove<?php echo e($course['item']['id']); ?>"
                    data-href="<?php echo e(route('course.cart.remove',$course['item']['id'])); ?>">
                        <i class="fas fa-times"></i>
                    </div>
                </figure>
            </li>



        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </ul>

    <div class="dropdown-cart-total">
        <span><?php echo e(__('Total')); ?></span>

        <span class="cart-total-price">
            <span class="cart-total"><?php echo e(Session::has('cart') ? $curr->sign.round((Session::get('cart')->totalPrice * $curr->value),2) : '0.00'); ?>

            </span>
        </span>
    </div>

    <div class="dropdown-cart-action">
        <a href="<?php echo e(route('front.checkout')); ?>" class="mybtn1"><?php echo e(__('Checkout')); ?></a>
    </div>
</div>

<?php else: ?>

<p class="mt-1 pl-3 text-left"><?php echo e(__('Cart is empty.')); ?></p>

<?php endif; ?>
<?php /**PATH /home/royaldem/public_html/project/resources/views/load/cart.blade.php ENDPATH**/ ?>