

<div class="modal fade" id="quizModalAdd" tabindex="-1" role="dialog" aria-labelledby="quizModalAddTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title"><?php echo e(__("Add New Quiz")); ?></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <div class="modal-body ml-2 mr-2">

                <form class="c-form" action="<?php echo e(route('instructor-lesson-store')); ?>" method="POST" enctype="multipart/form-data">

                    <?php echo $__env->make('includes.admin.form-both', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php echo e(csrf_field()); ?>


                    <div class="form-group">
                        <label for="section_id"><?php echo e(__('Select Section')); ?> *</label>
                        <select class="form-control" name="section_id" id="section_id" required>
                            <?php $__currentLoopData = $data->sections()->oldest('id')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($section->id); ?>"><?php echo e($section->title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="title"><?php echo e(__('Title')); ?> *</label>
                        <input class="form-control" type="text" name="title"  id="title" required="">
                    </div>


                    <div class="form-group">
                        <label for="details"><?php echo e(__('Details')); ?> *</label>
                        <textarea class="form-control" name="details" id="details" required></textarea>
                    </div>

                    <input type="hidden" name="type" value="Quiz">

                    <div class="text-right">
                        <button class="btn btn-success submit-btn" type="submit"><?php echo e(__('Submit')); ?></button>
                    </div>
                </form>

            </div>
            <div class="modal-footer">
            <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__("Close")); ?></a>
            </div>
        </div>
    </div>
</div>


<?php /**PATH /home/royaldem/public_html/project/resources/views/instructor/course/includes/lesson/quiz_add.blade.php ENDPATH**/ ?>