
<!DOCTYPE html>
<html lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php echo e($gs->title); ?></title>

	<!-- favicon -->
	<link rel="shortcut icon" href="<?php echo e(asset('assets/images/'.$gs->favicon)); ?>" type="image/x-icon">
	<!-- bootstrap -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>">
	<!-- Plugin css -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/plugin.css')); ?>">
	<!-- stylesheet -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/style.css')); ?>">
	<!-- responsive -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/responsive.css')); ?>">

</head>

<body>

	<!--Main Breadcrumb Area Start -->
	<div class="main-breadcrumb-area">
		<div class="container-fluid">
			<div class="row">
				<div class="col-lg-6">
					<ul class="pages">
						<li class="active">
							<a href="javascript:;">
								<?php echo e($data->title); ?>

							</a>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<!--Main Breadcrumb Area End -->


	<!-- Course Videos Page Start -->
	<section class="course-video-page">
		<div class="row">

			<div class="col-lg-9 cv-pr">



				<div class="video-play-area">

                    <?php if($lsn->type == 'Lesson'): ?>

                    <?php if($lsn->url != null): ?>
                        <?php if($lsn->video_file == 'youtube'): ?>

                        <?php if(strpos($lsn->url, 'https://www.youtube.com/watch?v') !== false): ?>
                            <iframe width="560" height="315" src="<?php echo e(str_replace("https://www.youtube.com/watch?v=","https://www.youtube.com/embed/",strtok($lsn->url, '&') )); ?>" frameborder="0"
                            allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        <?php else: ?> 
                            <iframe width="560" height="315" src="<?php echo e(str_replace("https://youtu.be/","https://www.youtube.com/embed/",$lsn->url)); ?>" frameborder="0"
                            allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        <?php endif; ?>

                        <?php elseif($lsn->video_file == 'vimeo'): ?>

                        <iframe width="560" height="315" src="<?php echo e(str_replace("https://vimeo.com/","https://player.vimeo.com/video/",$lsn->url)); ?>" frameborder="0"
                            allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

                        <?php else: ?>

                        <iframe width="560" height="315" src="<?php echo e($lsn->url); ?>" frameborder="0"
                            allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

                        <?php endif; ?>
                    <?php else: ?>
					<iframe width="560" height="315" src="<?php echo e(asset('assets/files/'.$lsn->file)); ?>" frameborder="0"
                        allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    <?php endif; ?>

                    <?php else: ?>

                    <div class="text-center">
                        <div class="mt-5">
                            <div id="quiz-body">

                            <?php if(Session::has('result')): ?>

                            <?php

                                $result = Session::get('result');

                            ?>
                                <div id="quiz-result" class="text-left">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card question-content mb-3">
                                                <div class="card-body">
                                                    <h5 class="card-title"><?php echo e(__('Review the course materials to expand your learning.')); ?></h5>
                                                    <p class="card-text"><?php echo e(__('You got')); ?> <?php echo e($result['correct_answers_count']); ?> <?php echo e(__('Out of')); ?> <?php echo e(count($lsn->questions)); ?> <?php echo e(__('Correct.')); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php $__currentLoopData = $lsn->questions()->oldest('pos')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php

                                    $options = json_decode($ans->options,true)

                                    ?>

                                    <div class="row mb-4">
                                        <div class="col-lg-12">
                                            <div class="card text-left card-with-no-color-no-border">
                                                <div class="card-body">
                                                    <h6 class="card-title">
                                                        <img height="15" src="<?php echo e($result['main_answers'][$loop->index] ? asset('assets/images/green-tick.png') : asset('assets/images/red-cross.png')); ?>" alt="">
                                                        <?php echo e($ans->title); ?>

                                                    </h6>
                                                    <?php $__currentLoopData = $result['correct_answers'][$loop->index]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <p class="card-text">
                                                        - <?php echo e($options[$opt]); ?>

                                                        <img height="15" src="<?php echo e(asset('assets/images/green-circle-tick.png')); ?>" alt="">
                                                    </p>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <p class="card-text">
                                                        <strong>
                                                            <?php echo e(__('Submitted Answers')); ?>:
                                                        </strong>
                                                        [<?php $__currentLoopData = $result['submitted_answers'][$loop->index]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo e($options[$sa]); ?><?php echo e($loop->last ? '' : ','); ?>

                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <div class="text-center">
                                        <a href="javascript:;" name="button" class="btn btn-danger mt-2 mb-3" onclick="location.reload();"><?php echo e(__('Take again')); ?></a>
                                    </div>
                                </div>

                            <?php else: ?>

                            <div class="" id="quiz-header">
                                <?php echo e(__('Quiz Title')); ?> : <strong><?php echo e($lsn->title); ?> </strong><br>
                                <?php echo e(__('Number Of Questions')); ?> : <strong><?php echo e(count($lsn->questions)); ?></strong><br>
                                <button type="button" name="button" class="btn btn-danger mt-2 mb-3 get-started" ><?php echo e(__('Get started')); ?></button>
                            </div>

                            <form id="quiz_form" action="<?php echo e(route('instructor-course-quiz-result')); ?>" method="post">

                                <?php echo e(csrf_field()); ?>


                                <input type="hidden" name="lesson_id" value="<?php echo e($lsn->id); ?>">

                                <?php echo $__env->make('includes.admin.form-error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <?php $__currentLoopData = $lsn->questions()->oldest('pos')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qsn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <div class="questions d-none" id="question-number-<?php echo e($loop->index + 1); ?>">
                                    <div class="row justify-content-center">
                                        <div class="col-lg-8">
                                            <div class="card text-left">
                                                <div class="card-body question-content">
                                                    <h6 class="card-title"><?php echo e(__('Question')); ?> <?php echo e($loop->index + 1); ?> : <strong><?php echo e($qsn->title); ?></strong></h6>
                                                </div>
                                                <ul class="list-group list-group-flush">
                                                    <?php $__currentLoopData = json_decode($qsn->options,true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="list-group-item quiz-options">
                                                        <div class="form-check">
                                                            <input type="hidden" name="answers[<?php echo e($loop->parent->index); ?>][]" value="0">
                                                            <input class="form-check-input ans-<?php echo e($loop->parent->index + 1); ?>" type="checkbox"  id="quiz-id-<?php echo e($qsn->id); ?>-option-id-<?php echo e($loop->index + 1); ?>">
                                                            <label class="form-check-label" for="quiz-id-<?php echo e($qsn->id); ?>-option-id-<?php echo e($loop->index + 1); ?>">
                                                                <?php echo e($opt); ?>

                                                            </label>
                                                        </div>
                                                    </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="<?php echo e($loop->last ? 'submit' : 'button'); ?>" name="button" data-class="ans-<?php echo e($loop->index + 1); ?>" class="btn btn-primary mt-2 mb-2 <?php echo e($loop->last ? 'final-btn' : 'next-btn'); ?>">
                                        <?php echo e($loop->last ? __('Check Answers') :  __('Next')); ?>

                                    </button>
                                </div>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </form>



                            <?php endif; ?>




                            </div>
                        </div>
                    </div>


                    <?php endif; ?>


                </div>



				<div class="course-information">

                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo e(__('Description')); ?>:</h5>
                            <p class="card-text">
                                <?php echo $lsn->details; ?>

                            </p>
                        </div>
                    </div>

				</div>
            </div>

			<div class="col-lg-3 cv-pl">
				<div class="course-video-list-area aside">
					<div class="content-accordion">
                            <?php $__currentLoopData = $data->sections()->oldest('pos')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mycard">
                                    <div class="mycard-header" id="headingLeson<?php echo e($section->id); ?>">
                                        <span class="header-title" data-toggle="collapse" data-target="#collapseLeson<?php echo e($section->id); ?>" aria-expanded="<?php echo e($lsn->section_id == $section->id ? 'true' : 'false'); ?>"
                                            aria-controls="collapseLeson<?php echo e($section->id); ?>">
                                            <div class="left-area">
                                                <div class="content">
                                                    <div class="top-area">
                                                        <span class="seson"><?php echo e(__('Section')); ?> <?php echo e($loop->index + 1); ?></span>
                                                    </div>
                                                    <h6 class="title">
                                                        <?php echo e($section->title); ?>

                                                    </h6>
                                                </div>
                                            </div>
                                        </span>
                                    </div>
                                    <div id="collapseLeson<?php echo e($section->id); ?>" class="collapse <?php echo e($lsn->section_id == $section->id ? 'show' : ''); ?>" aria-labelledby="headingLeson<?php echo e($section->id); ?>">

                                        <?php $__currentLoopData = $section->lessons()->oldest('pos')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mycard-body">
                                            <div class="single-video">
                                                <div class="top-heading-area">
                                                    <a href="<?php echo e(route('instructor-course-curriculam-lesson',$lesson->id)); ?>" class="title <?php echo e($lesson->id == $lsn->id ? 'active' : ''); ?>">
                                                        <?php echo e($loop->parent->index + 1); ?>.<?php echo e($loop->index + 1); ?> - <?php echo e($lesson->title); ?>

                                                    </a>
                                                </div>
                                                    <div class="bottom-area">
                                                        <?php if($lesson->duration != null): ?>
                                                            <i class="fas fa-play-circle"></i> <?php echo e($lesson->duration); ?>

                                                        <?php endif; ?>
                                                    </div>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</div>
				</div>
            </div>

		</div>
	</section>
	<!-- Course Videos Page End -->


	<!-- Back to Top Start -->
	<div class="bottomtotop">
		<i class="fas fa-chevron-right"></i>
	</div>
	<!-- Back to Top End -->


	<script>
		mainurl = '<?php echo e(route('front.index')); ?>';
	</script>

	<!-- jquery -->
	<script src="<?php echo e(asset('assets/front/js/jquery.js')); ?>"></script>
	<!-- bootstrap -->
	<script src="<?php echo e(asset('assets/front/js/bootstrap.min.js')); ?>"></script>
	<!-- popper -->
	<script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
	<!-- plugin js-->
	<script src="<?php echo e(asset('assets/front/js/plugin.js')); ?>"></script>
	<!-- custom js-->
	<script src="<?php echo e(asset('assets/front/js/custom.js')); ?>"></script>
	<!-- main -->
	<script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>

    <script>


        $('.get-started').on('click',function(){

            $('#quiz-header').addClass('d-none');
            $('#question-number-1').removeClass('d-none');

        });

        $('.next-btn').on('click',function(){

            var $this = $(this);
            var $class = $(this).data('class');

            if( $('.'+$class+':checked').length == 0 ){

                $('.alert-danger').show();
                $('.alert-danger ul').html('');
                $('.alert-danger ul').append('<?php echo e(__("You have to select an option.")); ?>');

            }else{
                $('.alert-danger').hide();
                $this.parent().addClass('d-none');
                $this.parent().next().removeClass('d-none');

            }

        });

$(document).on('change','.form-check-input',function(){

if(this.checked){

    $(this).prev().val('1');

}else{

    $(this).prev().val('0');

}

});


    </script>


</body>

</html>
<?php /**PATH /home/royaldem/public_html/project/resources/views/instructor/course/curriculam_view.blade.php ENDPATH**/ ?>