<?php $__env->startSection('content'); ?>

<!-- User Dashboard Area Start -->
<section class="user-dashboard">


  <div class="user-dashboard-menu-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h4 class="heading-title">
                    <?php echo e(__('Purchase History')); ?>

                </h4>
                <?php echo $__env->make('student.includes.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</div>

  <div class="user-dashboard-content-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="purchase-list">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('#Order')); ?></th>
                                    <th><?php echo e(__('Date')); ?></th>
                                    <th><?php echo e(__('Price')); ?></th>
                                    <th><?php echo e(__('Payment Type')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <h4 class="title">
                                            <?php echo e($order->order_number); ?>

                                        </h4>
                                    </td>
                                    <td>
                                        <div class="date">
                                            <?php echo e(date('D',strtotime($order->created_at))); ?>, <?php echo e(date('d-M-Y',strtotime($order->created_at))); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <div class="price">
                                            <?php echo e($order->currency_sign); ?><?php echo e(round(($order->pay_amount * $order->currency_value),2)); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <div class="payment-type">
                                            <?php echo e($order->method); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('student-order-details',$order->id)); ?>" class="mybtn1"><?php echo e(__('View Details')); ?></a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>


                </div>
            </div>
        </div>
    </div>
</div>
</section>

<!-- User Dashboard Area End -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/student/order/index.blade.php ENDPATH**/ ?>