<?php $__env->startSection('content'); ?>
<!--Main Breadcrumb Area Start -->
<div class="main-breadcrumb-area" style="background-image: url(<?php echo e($gs->breadcumb_banner ? asset('assets/images/'.$gs->breadcumb_banner):asset('assets/images/noimage.png')); ?>);">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <ul class="pages">
          <li>
            <a href="<?php echo e(route('front.index')); ?>">
              <?php echo e(__('Home')); ?>

            </a>
          </li>
          <li>
            <a href="<?php echo e(route('front.catalog',$course->category->slug)); ?>">
              <?php echo e($course->category->name); ?>

            </a>
          </li>
          <?php if($course->subcategory_id != null): ?>
          <li>
            <a href="<?php echo e(route('front.catalog', [$course->category->slug, $course->subcategory->slug])); ?>"><?php echo e($course->subcategory->name); ?></a>
         </li>
          <?php endif; ?>
          <li>
            <a href="<?php echo e(route('front.course',$course->slug)); ?>">
              <?php echo e($course->title); ?>

            </a>
          </li>
        </ul>
      </div>
    </div>
  </div>
</div>
<!--Main Breadcrumb Area End -->

<!-- Course Details Page Start -->
<section class="course-details-page">
  <div class="details-top-jumboron">
    <div class="container">
      <div class="row">
        <div class="col-lg-8">
          <div class="content">
            <div class="left-area">
              <div class="top-area">
                <p><?php echo e(__('Created by')); ?> : <?php echo e(!empty($course->instructor) ? $course->instructor->showName() : DB::table('admins')->first()->name); ?></p>
                <p><?php echo e(__('Last Updated')); ?> <?php echo e(date('D',strtotime($course->updated_at))); ?>, <?php echo e(date('d-M-Y',strtotime($course->updated_at))); ?></p>
              </div>
            <h4 class="title">
              <?php echo e($course->title); ?>

            </h4>
            <p class="text">
              <?php echo e($course->sortdescription); ?>

            </p>
            <?php if(App\Models\Rating::normalRating($course->id) != 0): ?>
            <div class="reating-area">
              <span class="number"><?php echo e(App\Models\Rating::normalRating($course->id)); ?></span>
              <div class="stars">
                  <div class="ratings">
                      <div class="empty-stars"></div>
                      <div class="full-stars" style="width:<?php echo e(App\Models\Rating::ratings($course->id)); ?>%"></div>
                    </div>
              </div>
              <div class="total-star">
                (<?php echo e(App\Models\Rating::ratingCount($course->id)); ?>)
              </div>
            </div>
            <?php endif; ?>
            <ul class="short-info">
                <?php if($course->convertTime() != ''): ?>
                <li>
                  <?php echo e($course->convertTime()); ?>

                </li>
                <?php endif; ?>
                <li>
                  <?php echo e($course->sections()->withCount('lessons')->get()->sum('lessons_count')); ?> <?php echo e(__('lecture(s)')); ?>

                </li>
                <li>
                    <?php echo e($course->level); ?> <?php echo e(__('Level')); ?>

                </li>
            </ul>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="details-main-content">
    <div class="container">
      <div class="row">
        <div class="col-lg-8 order-last order-lg-first">
          <?php if($course->outcomes != null): ?>
          <div class="what-you-learn">
            <h4 class="title">
              <?php echo e(__("What you'll learn")); ?>

            </h4>
            <ul class="learn-list">
            <?php $__currentLoopData = explode(',,,', $course->outcomes); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li>
                <?php echo e($ot); ?>

              </li>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
          <?php endif; ?>
          <div class="course-content">
            <h4 class="title">
              <?php echo e(__('Course Content')); ?>

            </h4>

            <div class="content-accordion">

                <?php $__currentLoopData = $course->sections()->oldest('pos')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div class="mycard">
                    <div class="mycard-header" id="heading<?php echo e($section->id); ?>">
                        <span class="header-title" data-toggle="collapse" data-target="#collapse<?php echo e($section->id); ?>" aria-expanded="<?php echo e($loop->first ? 'true' : ''); ?>" aria-controls="collapse<?php echo e($section->id); ?>">
                            <b><?php echo e($section->title); ?></b> <span><?php echo e($course->convertSectionTime($section->id)); ?></span>
                        </span>
                    </div>

                    <div id="collapse<?php echo e($section->id); ?>" class="collapse <?php echo e($loop->first ? 'show' : ''); ?>" aria-labelledby="heading<?php echo e($section->id); ?>">
                        <div class="mycard-body">
                            <div class="video-list">

                                <?php $__currentLoopData = $section->lessons()->oldest('pos')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <div class="single-video">
                                    <div class="left">
                                         <img src="<?php echo e($lesson->type == 'Lesson' ? asset('assets/images/video.png') : asset('assets/images/quiz.png')); ?>" alt="" height="16"> <?php echo e($lesson->title); ?>

                                    </div>
                                    <?php if($lesson->duration != null): ?>
                                    <div class="right">
                                        <span class="time"><?php echo e($lesson->duration); ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </div>
          </div>
          <?php if($course->requirements != null): ?>
          <div class="requirements-list">
            <h4 class="title"><?php echo e(__('Requirements')); ?></h4>
            <ul>

            <?php $__currentLoopData = explode(',,,', $course->requirements); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

              <li>
                <?php echo e($rq); ?>

              </li>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </ul>
          </div>
          <?php endif; ?>
          <div class="course-description">
            <h4 class="title"><?php echo e(__('Description')); ?></h4>
            <div class="description-content">
              <?php echo $course->description; ?>

            </div>
          </div>
          <div class="students-also-bought">
            <h4 class="header-title">
              <?php echo e(__('Related Courses')); ?>

            </h4>
            <div class="row">
              <div class="col-lg-12">
                <div class="product-slider2">

                  <?php $__currentLoopData = $course->category->courses()->whereStatus(1)->where('id','!=',$course->id)->take(8)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rcourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                  <div class="single-slider">
										<div class="single-course">
											<div class="img">
												<img src="<?php echo e(asset('assets/images/courses/'.$rcourse->photo)); ?>" alt="course">
											</div>
											<div class="content">
                                                <p class="author">
                        <a href="<?php echo e(!empty($rcourse->instructor) ? route('instructor.details',$rcourse->instructor->instructor_slug) : route('instructor.details',DB::table('admins')->first()->slug)); ?>">
                          <?php echo e(!empty($rcourse->instructor) ? $rcourse->instructor->instructor_name : DB::table('admins')->first()->name); ?>

                        </a>
                                                </p>
												<a href="<?php echo e(route('front.course',$rcourse->slug)); ?>">
													<h4 class="title">
														<?php echo e($rcourse->showTitle()); ?>

													</h4>
												</a>

                        <?php if(App\Models\Rating::normalRating($rcourse->id) != 0): ?>
                        <div class="reating-area">
                          <span class="number"><?php echo e(App\Models\Rating::normalRating($rcourse->id)); ?></span>
                          <div class="stars">
                              <div class="ratings">
                                  <div class="empty-stars"></div>
                                  <div class="full-stars" style="width:<?php echo e(App\Models\Rating::ratings($rcourse->id)); ?>%"></div>
                                </div>
                          </div>
                          <div class="total-star">
                            (<?php echo e(App\Models\Rating::ratingCount($rcourse->id)); ?>)
                          </div>
                        </div>
                        <?php endif; ?>
                        <?php if($course->price == 0): ?>

                        <p class="price">
                          <?php echo e(__('Free')); ?>

                        </p>

                        <?php else: ?>

                        <p class="price">
                          <?php echo e($curr->sign); ?><?php echo e(round(($course->price * $curr->value),2)); ?> <del><?php echo e($curr->sign); ?><?php echo e(round(($course->discount_price * $curr->value),2)); ?></del>
                        </p>

                        <?php endif; ?>
											</div>
										</div>
                  </div>

                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="about-instructor">
                <h4 class="header-title">
                  <?php echo e(__('About The Instructor')); ?>:
                </h4>
                <?php if($instructor == 'admin'): ?>

                <div class="about-instructor-content">
                  <div class="about-left-content">
                    <div class="images">
                      <img  src=" <?php echo e($admin->photo ? asset('assets/images/admins/'.$admin->photo) : asset('assets/images/placeholder.jpg')); ?>" alt="">
                    </div>
                    <ul class="info-list">
                      <li>
                        <i class="fas fa-star"></i> <span><?php echo e(\App\Models\Rating::InstructorNormalRatings(0)); ?></span> <?php echo e(__('Instructor Rating')); ?>

                      </li>
                      <li>
                        <i class="fas fa-comment"></i> <span><?php echo e(\App\Models\Course::where('user_id','=',0)->withCount('ratings')->get()->sum('ratings_count')); ?></span> <?php echo e(__('Reviews')); ?>

                      </li>
                      <li>
                        <i class="fas fa-user"></i> <span><?php echo e(\App\Models\Course::where('user_id','=',0)->withCount('enrolled_courses')->get()->sum('enrolled_courses_count')); ?></span> <?php echo e(__('Students')); ?>

                      </li>
                      <li>
                        <i class="fas fa-play-circle"></i> <span><?php echo e(DB::table('courses')->whereUserId(0)->count()); ?></span> <?php echo e(__('Courses')); ?>

                      </li>
                    </ul>
                  </div>
                  <div class="about-right-content">
                    <h4 class="name">
                      <?php echo e($admin->name); ?>

                    </h4>
                    <p class="job-title">
                      <?php echo e($admin->address); ?>

                    </p>
                    <div class="about-description">
                        <?php echo $admin->biography; ?>

                    </div>
                  </div>
                </div>


                <?php else: ?>

                <div class="about-instructor-content">
                  <div class="about-left-content">
                    <div class="images">
                      <img src="<?php echo e($instructor->photo ? asset('assets/images/users/'.$instructor->photo) : asset('assets/images/placeholder.jpg')); ?>" alt="">
                    </div>
                    <ul class="info-list">
                      <li>
                        <i class="fas fa-star"></i> <span><?php echo e(\App\Models\Rating::InstructorNormalRatings($instructor->id)); ?></span> <?php echo e(__('Instructor Rating')); ?>

                      </li>
                      <li>
                        <i class="fas fa-comment"></i> <span><?php echo e($instructor->courses()->withCount('ratings')->get()->sum('ratings_count')); ?></span> <?php echo e(__('Reviews')); ?>

                      </li>
                      <li>
                        <i class="fas fa-user"></i> <span><?php echo e($instructor->courses()->withCount('enrolled_courses')->get()->sum('enrolled_courses_count')); ?></span> <?php echo e(__('Students')); ?>

                      </li>
                      <li>
                        <i class="fas fa-play-circle"></i> <span><?php echo e($instructor->courses->count()); ?></span> <?php echo e(__('Courses')); ?>

                      </li>
                    </ul>
                  </div>
                  <div class="about-right-content">
                    <h4 class="name">
                      <?php echo e($instructor->instructor_name); ?>

                    </h4>
                    <p class="job-title">
                      <?php echo e($instructor->address); ?>

                    </p>
                    <div class="about-description">
                        <?php echo $instructor->bio; ?>

                    </div>
                  </div>
                </div>


                <?php endif; ?>
              </div>

              <div class="course-review-area">
                <h4 class="header-title">
                  <?php echo e(__('Student Feedback')); ?>:
                </h4>
                <div class="rating-report-box" id="rating-load">
                  <div class="rating-left-area">
                    <span class="rating-number"><?php echo e(App\Models\Rating::normalRating($course->id)); ?></span>

                    <div class="stars">
                        <div class="ratings">
                            <div class="empty-stars"></div>
                            <div class="full-stars" style="width:<?php echo e(App\Models\Rating::ratings($course->id)); ?>%"></div>
                          </div>
                    </div>

                    <span class="text"><?php echo e(__('Course Rating')); ?></span>
                  </div>
                  <div class="rating-right-area">
                    <div class="rating-progress-bar">
                      <div class="progress">
                        <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e(App\Models\Rating::customRatings($course->id,5)); ?>%" aria-valuenow="<?php echo e(App\Models\Rating::customRatings($course->id,5)); ?>" aria-valuemin="0" aria-valuemax="100"><?php echo e(App\Models\Rating::customRatings($course->id,5)); ?>%</div>
                      </div>
                      <div class="progress">
                        <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e(App\Models\Rating::customRatings($course->id,4)); ?>%" aria-valuenow="<?php echo e(App\Models\Rating::customRatings($course->id,4)); ?>" aria-valuemin="0" aria-valuemax="100"><?php echo e(App\Models\Rating::customRatings($course->id,4)); ?>%</div>
                      </div>
                      <div class="progress">
                        <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e(App\Models\Rating::customRatings($course->id,3)); ?>%" aria-valuenow="<?php echo e(App\Models\Rating::customRatings($course->id,3)); ?>" aria-valuemin="0" aria-valuemax="100"><?php echo e(App\Models\Rating::customRatings($course->id,3)); ?>%</div>
                      </div>
                      <div class="progress">
                        <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e(App\Models\Rating::customRatings($course->id,2)); ?>%" aria-valuenow="<?php echo e(App\Models\Rating::customRatings($course->id,2)); ?>" aria-valuemin="0" aria-valuemax="100"><?php echo e(App\Models\Rating::customRatings($course->id,2)); ?>%</div>
                      </div>
                      <div class="progress">
                        <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e(App\Models\Rating::customRatings($course->id,1)); ?>%" aria-valuenow="<?php echo e(App\Models\Rating::customRatings($course->id,1)); ?>" aria-valuemin="0" aria-valuemax="100"><?php echo e(App\Models\Rating::customRatings($course->id,1)); ?>%</div>
                      </div>
                    </div>
                  </div>
                </div>


                <div class="user-review-area">
                  <h4 class="header-title">
                    <?php echo e(__('Review(s)')); ?>:
                  </h4>

                  <div id="course-reviews">
                    <?php $__currentLoopData = $course->ratings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rating): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="user-single-review">
                        <div class="review-left">
                            <img src="<?php echo e($rating->user->photo ? asset('assets/images/users/'.$rating->user->photo) : asset('assets/images/placeholder.jpg')); ?>" alt="">
                            <h6 class="name"><?php echo e($rating->user->showName()); ?></h6>
                            <span class="time"><?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$rating->review_date)->diffForHumans()); ?></span>
                        </div>
                        <div class="review-right">
                            <div class="stars">
                            <?php for($i = 1; $i <= $rating->rating; $i++): ?>
                                <i class="fas fa-star"></i>
                            <?php endfor; ?>
                            </div>
                            <p class="review-content">
                            <?php echo e($rating->review); ?>

                            </p>
                        </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>

                <div id="coment-area">
                  <h4 class="header-title">
                    <?php echo e(__('Write a review')); ?>:
                  </h4>

                <div class="review-area">
                    <div class="star-area">
                        <ul class="star-list">
                            <li class="stars" data-val="1">
                                <i class="fas fa-star"></i>
                            </li>
                            <li class="stars" data-val="2">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </li>
                            <li class="stars" data-val="3">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </li>
                            <li class="stars" data-val="4">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </li>
                            <li class="stars active" data-val="5">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="write-comment-area">

                    <div class="gocover"
                    style="background: url(<?php echo e(asset('assets/images/'.$gs->loader)); ?>) no-repeat scroll center center rgba(45, 45, 45, 0.5);">
                  </div>

                    <?php if(Auth::check()): ?>

                    <form id="reviewform" action="<?php echo e(route('student.review.submit')); ?>" data-href="<?php echo e(route('front.reviews',$course->id)); ?>" data-side-href="<?php echo e(route('front.side.reviews',$course->id)); ?>" method="POST">

                    <?php else: ?>

                    <form action="<?php echo e(route('student.review.submit')); ?>" method="POST">

                    <?php endif; ?>

                        <?php echo e(csrf_field()); ?>


                        <input type="hidden" id="rating" name="rating" value="5">
                        <input type="hidden" name="course_id" value="<?php echo e($course->id); ?>">
                        <div class="row">
                            <div class="col-lg-12">
                                <textarea name="review" placeholder="<?php echo e(__('Write Your Review')); ?>" required=""></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button class="mybtn1" id="review-btn" type="submit"><?php echo e(__('Submit')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>


                  </div>


                </div>
              </div>


          </div>
          

        <div class="col-lg-4">
          <div class="right-content">
            <div class="video-area">
              <img src="<?php echo e(asset('assets/images/courses/'.$course->photo)); ?>" alt="course">

              <?php if(strpos($course->course_overview_url, 'https://www.youtube.com/watch?v') !== false): ?>

                <a href="<?php echo e(strtok($course->course_overview_url, '&')); ?>" class="popup-button play-video mfp-iframe">
                  <i class="fas fa-play"></i>
                </a>

              <?php elseif(strpos($course->course_overview_url, 'https://youtu.be/') !== false): ?>

              
                <a href="<?php echo e(str_replace("https://youtu.be/","https://www.youtube.com/watch?v=",$course->course_overview_url)); ?>" class="popup-button play-video mfp-iframe">
                  <i class="fas fa-play"></i>
                </a>

              <?php else: ?> 

                <a href="<?php echo e($course->course_overview_url); ?>" class="popup-button play-video mfp-iframe">
                  <i class="fas fa-play"></i>
                </a>

              <?php endif; ?>

            </div>
            <div class="price-area">
              <?php if($course->price == 0): ?>

                <?php echo e(__('Free')); ?>


              <?php else: ?>

              <?php echo e($curr->sign); ?><?php echo e(round(($course->price * $curr->value),2)); ?> <del><?php echo e($curr->sign); ?><?php echo e(round(($course->discount_price * $curr->value),2)); ?></del>


              <?php endif; ?>

            </div>
            <div class="action-buttons">
            <?php if($course->price == 0): ?>
            <a href="<?php echo e(route('student-enroll')); ?>?course_id=<?php echo e($course->id); ?>" class="buy-now  btn-success" ><i class="far fa-credit-card"></i><?php echo e(__('Enroll Now')); ?></a>
            <?php else: ?>
            <a href="javascript:;" data-href="<?php echo e(route('course.cart.add',$course->id)); ?>?ref=<?php echo e($affilate_user); ?>&type=<?php echo e($type); ?>" class="add-cart add-to-cart btn-danger"><i class="fas fa-cart-plus"></i><?php echo e(__('Add To Cart')); ?></a>
            <a href="<?php echo e(route('course.cart.quickadd',$course->id)); ?>?ref=<?php echo e($affilate_user); ?>" class="buy-now  btn-success" ><i class="far fa-credit-card"></i><?php echo e(__('Buy Now')); ?></a>
            <?php endif; ?>
              <?php if(Auth::check()): ?>

              <a href="javascript:;" data-href="<?php echo e(route('student-wishlist-add',$course->id)); ?>" class="add-wishlist add-to-wish btn-info"><i class="far fa-heart"></i><?php echo e(__('Wishlist')); ?></a>

              <?php else: ?>

              <a href="<?php echo e(route('student-wishlist-add',$course->id)); ?>" class="add-wishlist btn-info"><i class="far fa-heart"></i><?php echo e(__('Wishlist')); ?></a>

              <?php endif; ?>
              <?php if(Auth::check()): ?>

              <a href="javascript:;" data-href="<?php echo e(\Request::url().'?ref='.Auth::user()->affilate_code); ?>" class="add-wishlist add-to-affilate btn-primary"><i class="fas fa-link"></i><?php echo e(__('Copy Affiliate Link')); ?></a>

              <?php endif; ?>
            </div>

            <?php if($course->include_icon != null): ?>
            <div class="course-includes">
              <h4 class="title"><?php echo e(__('This course includes')); ?></h4>
              <ul class="include-list">
                <?php $__currentLoopData = array_combine(explode(',,,', $course->include_icon),explode(',,,', $course->include_text)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li>
                    <i class="<?php echo e($key); ?>"></i> <?php echo e($value); ?>

                  </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>

            <!-- AddToAny BEGIN -->
            <div class="a2a_kit a2a_kit_size_32 a2a_default_style pl-3 pt-2">
              <a class="a2a_dd" href="https://www.addtoany.com/share"></a>
              <a class="a2a_button_facebook"></a>
              <a class="a2a_button_linkedin"></a>
              <a class="a2a_button_pinterest"></a>
              <a class="a2a_button_whatsapp"></a>
            </div>
            <script async src="https://static.addtoany.com/menu/page.js"></script>
            <!-- AddToAny END -->


          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Course Details Page End -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/front/course.blade.php ENDPATH**/ ?>