

<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Withdraws')); ?></h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('instructor-dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
        <li class="breadcrumb-item"><a href="<?php echo e(route('instructor-wt-index')); ?>"><?php echo e(__('Withdraws')); ?></a></li>
        </ol>
        </div>
    </div>


    <!-- Row -->
    <div class="row mt-3">
      <!-- Datatables -->
      <div class="col-lg-12">

        <?php echo $__env->make('includes.admin.form-success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <div class="card mb-4">
          <div class="table-responsive p-3">
            <table class="table align-items-center table-flush" id="geniustable">
              <thead class="thead-light">
                <tr>
                  <th><?php echo e(__('Withdraw Date')); ?></th>
                  <th><?php echo e(__('Method')); ?></th>
                  <th><?php echo e(__('Account')); ?></th>
                  <th><?php echo e(__('Amount')); ?></th>
                  <th><?php echo e(__('Status')); ?></th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                      <td><?php echo e(date('d-M-Y',strtotime($withdraw->created_at))); ?></td>
                      <td><?php echo e($withdraw->method); ?></td>
                      <?php if($withdraw->method != "Bank"): ?>
                          <td><?php echo e($withdraw->acc_email); ?></td>
                      <?php else: ?>
                          <td><?php echo e($withdraw->iban); ?></td>
                      <?php endif; ?>
                      <td><?php echo e($sign->sign); ?><?php echo e(round($withdraw->amount * $sign->value , 2)); ?></td>
                      <td><?php echo e(ucfirst($withdraw->status)); ?></td>
                  </tr>  
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>         
            </tbody>
            </table>
          </div>
        </div>
      </div>
      <!-- DataTable with Hover -->

    </div>
    <!--Row-->




<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="modal1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">

    <div class="modal-header d-block text-center">
        <h4 class="modal-title d-inline-block"><?php echo e(__('Confirm Delete')); ?></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
    </div>
                <div class="modal-body">
            <p class="text-center"><?php echo e(__('You are about to delete this Conversation.')); ?></p>
            <p class="text-center"><?php echo e(__('Do you want to proceed?')); ?></p>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Cancle')); ?></button>
                    <a class="btn btn-danger btn-ok"><?php echo e(__('Delete')); ?></a>
                </div>
            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">

var table = $('#geniustable').DataTable();
$(function() {
            $(".btn-area").append('<div class="col-sm-12 col-md-4 text-right">'+
                '<a class="btn btn-primary" href="<?php echo e(route('instructor-wt-create')); ?>">'+
            '<i class="fas fa-plus"></i> <?php echo e('New Withdraw'); ?>'+
            '</a>'+
            '</div>');
        });	

</script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/instructor/withdraw/index.blade.php ENDPATH**/ ?>