<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="d-sm-flex align-items-center justify-content-between">
    <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Add New Withdraw')); ?> <a class="btn btn-primary btn-rounded btn-sm" href="<?php echo e(route('instructor-wt-index')); ?>"><i class="fas fa-arrow-left"></i> <?php echo e(__('Back')); ?></a></h5>
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="<?php echo e(route('instructor-dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
        <li class="breadcrumb-item"><a href="<?php echo e(route('instructor-wt-index')); ?>"><?php echo e(__('Withdraw')); ?></a></li>
        <li class="breadcrumb-item"><a href="<?php echo e(route('instructor-wt-create')); ?>"><?php echo e(__('Add New Withdraw')); ?></a></li>
    </ol>
    </div>
</div>

<div class="row justify-content-center mt-3">
  <div class="col-lg-6">
    <!-- Form Basic -->
    <div class="card mb-4">
      <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Add New Withdraw Form')); ?></h6>
      </div>

      <div class="card-body">
        <div class="gocover" style="background: url(<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
        <form class="geniusform" action="<?php echo e(route('instructor-wt-store')); ?>" method="POST" enctype="multipart/form-data">

            <?php echo $__env->make('includes.admin.form-both', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo e(csrf_field()); ?>


            <div class="form-group">
                <label class="control-label col-sm-4" for="name"><?php echo e(__('Current Balance')); ?>

                    <?php echo e($curr->sign); ?><?php echo e(round((Auth::user()->balance * $curr->value),2)); ?></label>
            </div>




            <div class="form-group">
                <label for="withmethod"><?php echo e(__('Withdraw Method')); ?></label>
                <select class="form-control mb-3" id="withmethod" name="methods">
                    <option value=""><?php echo e(__('Select Withdraw Method')); ?></option>
                    <option value="Paypal"><?php echo e(__('Paypal')); ?></option>
                    <option value="Skrill"><?php echo e(__('Skrill')); ?></option>
                    <option value="Payoneer"><?php echo e(__('Payoneer')); ?></option>
                    <option value="Bank"><?php echo e(__('Bank')); ?></option>
                </select>
              </div>

            <div class="form-group">
                <label for="amount"><?php echo e(__('Withdraw Amount')); ?> *</label>
                <input type="text" class="form-control" id="amount" name="amount"  placeholder="<?php echo e(__('Withdraw Amount')); ?>" value="" required>
            </div>

            <div id="paypal" style="display: none;">

                <div class="form-group">
                    <label class="control-label col-sm-12" for="eml"><?php echo e(__('Enter Account Email')); ?> *</label>
                        <input name="acc_email" id="eml" placeholder="<?php echo e(__('Enter Account Email')); ?>" class="form-control"
                            value="<?php echo e(old('email')); ?>" type="email">
                </div>

            </div>

            <div id="bank" style="display: none;">
                <div class="form-group">
                    <label for="acc_email"><?php echo e(__('Enter Account Email')); ?> *</label>
                    <input type="email" class="form-control" id="acc_email" name="acc_email"  placeholder="<?php echo e(__('Enter Account Email')); ?>" value="" required>
                </div>

                <div class="form-group">
                    <label for="iban"><?php echo e(__('Enter IBAN/Account No')); ?> *</label>
                    <input type="text" class="form-control" id="iban" name="iban"  placeholder="<?php echo e(__('Enter IBAN/Account No')); ?>" value="" required>
                </div>

                <div class="form-group">
                    <label for="acc_name"><?php echo e(__('Enter Account Name')); ?> *</label>
                    <input type="text" class="form-control" id="acc_name" name="acc_name"  placeholder="<?php echo e(__('Enter Account Name')); ?>" value="" required>
                </div>

                <div class="form-group">
                    <label for="address"><?php echo e(__('Enter Address')); ?> *</label>
                    <input type="text" class="form-control" id="address" name="address"  placeholder="<?php echo e(__('Enter Address')); ?>" value="" required>
                </div>

                <div class="form-group">
                    <label for="country"><?php echo e(__('Enter Country')); ?> *</label>
                    <input type="text" class="form-control" id="country" name="country"  placeholder="<?php echo e(__('Enter Country')); ?>" value="" required>
                </div>

                <div class="form-group">
                    <label for="swift"><?php echo e(__('Enter Swift Code')); ?> *</label>
                    <input type="text" class="form-control" id="swift" name="swift"  placeholder="<?php echo e(__('Swift Code')); ?>" value="" required>
                </div>
            </div>

          <div class="form-group">
            <label for="reference"><?php echo e(__('Additional Reference(Optional)')); ?> </label>
            <textarea class="form-control"  id="reference" name="reference" rows="3"  placeholder="<?php echo e(__('Additional Reference(Optional)')); ?>"></textarea>
          </div>

        <?php if($gs->withdraw_fee != 0 && $gs->withdraw_charge != 0): ?>

        <div id="resp" class="col-md-12">
            <span class="help-block">
                <strong><?php echo e(__('Withdraw Fee')); ?> <?php echo e($sign->sign); ?><?php echo e($gs->withdraw_fee); ?>

                    <?php echo e(__('and')); ?> <?php echo e($gs->withdraw_charge); ?>%
                    <?php echo e(__('will deduct from your account.')); ?>

                </strong>
            </span>
        </div>

        <?php endif; ?>

        <br>

            <button type="submit" id="submit-btn" class="btn btn-primary"><?php echo e(__('Submit')); ?></button>

        </form>
      </div>
    </div>

    <!-- Form Sizing -->

    <!-- Horizontal Form -->

  </div>

</div>
<!--Row-->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>


<script type="text/javascript">
    $("#withmethod").change(function () {
        var method = $(this).val();
        if (method == "Bank") {

            $("#bank").show();
            $("#bank").find('input, select').attr('required', true);

            $("#paypal").hide();
            $("#paypal").find('input').attr('required', false);

        }
        if (method != "Bank") {
            $("#bank").hide();
            $("#bank").find('input, select').attr('required', false);

            $("#paypal").show();
            $("#paypal").find('input').attr('required', true);
        }
        if (method == "") {
            $("#bank").hide();
            $("#paypal").hide();
        }

    })
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/instructor/withdraw/withdraw.blade.php ENDPATH**/ ?>