

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Purchase Details')); ?><a class="btn btn-primary btn-rounded btn-sm ml-2" href="<?php echo e(route('admin-purchase-index')); ?>"><i class="fas fa-arrow-left"></i> <?php echo e(__('Back')); ?></a></h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
            <li class="breadcrumb-item"><a href="javascript:;"><?php echo e(__('All Purchase')); ?></a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin-purchase-index')); ?>"><?php echo e(__('Purchase')); ?></a></li>
        </ol>
        </div>
    </div>
    <section class="success">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="product-invoice">
                        <main class="columns">
                            <div class="inner-container">

                            <div class="table-responsive">
                                <table class="table invoice">
                                    <tbody>
                                    <tr class="header">
                                        <td class="">
                                            <img src="<?php echo e(asset('assets/images/'.$gs->logo)); ?>" alt="Company Name">
                                        </td>
                                        <td class="align-right">
                                        <h2><?php echo e(__('Invoice')); ?></h2>
                                        </td>
                                    </tr>
                                    <tr class="intro">
                                        <td class="">
                                            <strong><?php echo e(__('Name')); ?>:</strong> <?php echo e($order->user->showName()); ?><br>
                                            <strong><?php echo e(__('Email')); ?>:</strong> <?php echo e($order->user->email); ?>

                                        </td>
                                        <td class="text-right">
                                            <strong><?php echo e(__('Order Number')); ?>:</strong> <?php echo e($order->order_number); ?><br>
                                            <strong><?php echo e(__('Purchase Date')); ?>:</strong> <?php echo e(date('l m, Y', strtotime($order->created_at))); ?>

                                        </td>
                                    </tr>
                                    <tr class="details">
                                        <td colspan="2">
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th>
                                                            <?php echo e(__('Course Name')); ?>

                                                        </th>
                                                        <th>
                                                            <?php echo e(__('Total')); ?>

                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $cart['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr class="item">
                                                            <td>
                                                                <?php echo e($course['item']['title']); ?>

                                                            </td>
                                                            <td>
                                                                <?php echo e($order->currency_sign); ?><?php echo e(round(($course['price'] * $order->currency_value),2)); ?>

                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr class="totals">
                                        <td></td>
                                        <td>
                                            <table class="table">
                                                <tbody>

                                                    <?php if($order->discount != 0): ?>
                                                    <tr class="subtotal">
                                                        <td class="label text-right"><?php echo e(__('Discount')); ?></td>
                                                        <td id="padding-right-11" class="num"><?php echo e($order->currency_sign); ?><?php echo e(round(($order->discount * $order->currency_value),2)); ?></td>
                                                    </tr>
                                                    <?php endif; ?>

                                                    <tr class="total">
                                                        <td class="label text-right"><?php echo e(__('Total')); ?></td>
                                                        <td class="num"><?php echo e($order->currency_sign); ?><?php echo e(round(($order->pay_amount * $order->currency_value),2)); ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            </div>
                        </main>
                    </div>
                </div>
            </div>
        </div>

    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/admin/order/details.blade.php ENDPATH**/ ?>