
<!DOCTYPE html>
<html lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="keywords" content="<?php echo e($seo->meta_keys); ?>">
	<title><?php echo e($gs->title); ?></title>

	<!-- favicon -->
	<link rel="shortcut icon" href="<?php echo e(asset('assets/images/'.$gs->favicon)); ?>" type="image/x-icon">
	<!-- bootstrap -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>">
	<!-- Plugin css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/plugin.css')); ?>">
    <!-- Toastr css -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/toastr.css')); ?>">
	<!-- stylesheet -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/style.css')); ?>">
	<!-- responsive -->
	<?php echo $__env->yieldContent('styles'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/responsive.css')); ?>">

	<link rel="stylesheet" id="color" href="<?php echo e(asset('assets/front/css/style.php?colors='.str_replace('#','', $gs->colors))); ?>">


	<?php if(!empty($seo->google_analytics)): ?>
	<script>
		window.dataLayer = window.dataLayer || [];
		function gtag() {
				dataLayer.push(arguments);
		}
		gtag('js', new Date());
		gtag('config', '<?php echo e($seo->google_analytics); ?>');
	</script>
	<?php endif; ?>


</head>

<body>

    <?php if($gs->is_loader == 1): ?>
	<div class="preloader" id="preloader" style="background: url(<?php echo e(asset('assets/images/'.$gs->loader)); ?>)"></div>
    <?php endif; ?>

	<!--Main-Menu Area Start-->
	<div class="mainmenu-area">
		<div class="container-fluid">
			<div class="row">
				<div class="col-lg-12">
					<nav class="my-navbar">
						<div class="logoarea">
							<a class="navbar-brand" href="<?php echo e(route('front.index')); ?>">
								<img src="<?php echo e(asset('assets/images/'.$gs->logo)); ?>" alt="logo">
							</a>
							<div class="categorimenu-wrapper">
								<div class="categories_menu">
									<div class="categories_title">
										<h2 class="categori_toggle"><i class="fa fa-th left-icon"></i> <?php echo e(__('Categories')); ?>

											</i>
										</h2>
									</div>
									<div class="categories_menu_inner">
										<ul>

                                            <?php $__currentLoopData = \App\Models\Category::where('register_id',0)->whereStatus(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<li class="dropdown_list ">
												<div class="img">
													<img src="<?php echo e(asset('assets/images/categories/'.$category->photo)); ?>"
														alt="">
												</div>
												<div class="link-area">
                                                    <span><a href="<?php echo e(route('front.catalog',$category->slug)); ?>"><?php echo e($category->name); ?></a></span>
                                                    <?php if(count($category->subs) > 0): ?>
													<a href="javascript:;">
														<i class="fa fa-angle-right" aria-hidden="true"></i>
                                                    </a>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if(count($category->subs) > 0): ?>
                                                <ul class="categories_mega_menu column_1">
													<?php $__currentLoopData = $category->subs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<?php if($subcat->register_id == 0): ?>
                                                    <li>
                                                        <a href="<?php echo e(route('front.catalog',[$category->slug, $subcat->slug])); ?>"><?php echo e($subcat->name); ?></a>
													</li>
													<?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                                <?php endif; ?>
											</li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

										</ul>
									</div>
								</div>
							</div>
							<div class="search-form order-first order-lg-last">
								<form action="<?php echo e(route('front.catalog', [Request::route('category'),Request::route('subcategory')])); ?>" method="GET">
									<input id="course_name" type="text" name="search" placeholder="<?php echo e(__('Search For Anything')); ?>" autocomplete="off" required>
									<button type="submit"><i class="fas fa-search"></i></button>
									<div class="autocomplete">
										<div id="myInputautocomplete-list" class="autocomplete-items"></div>
									</div>
								</form>
							</div>
						</div>
						<div id="main_menu" class="order-first order-lg-last">
							<ul class="navbar-nav">

								<li class="nav-item dropdown ml-0 mr-3">
									<?php if(Auth::check()): ?>
									<a class="nav-link log-reg-btn" href="<?php echo e(route('student-instructor-application')); ?>"><?php echo e(__('Start Teaching Today')); ?></a>
								<?php else: ?>
									<a class="nav-link log-reg-btn" href="javascript:;"   data-toggle="modal" data-target="#bcomeinstructormodal">
										<?php echo e(__('Become An Instructor')); ?>

									</a>
								<?php endif; ?>
									</li>



								<li class="nav-item my-dropdown" data-toggle="tooltip" data-placement="top" title="Cart">
									<a href="#" class="cart carticon">
										<div class="icon">
											<i class="fas fa-shopping-cart"></i>
											<span class="cart-quantity" id="cart-count"><?php echo e(Session::has('cart') ? count(Session::get('cart')->items) : '0'); ?></span>
										</div>

									</a>
									<div class="my-dropdown-menu" id="cart-items">
                                        <?php echo $__env->make('load.cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									</div>
                                </li>


                                <?php if(Auth::check()): ?>

									<?php if(Auth::user()->register_id == 0): ?>
										<li class="nav-item dropdown">
											<a class="nav-link log-reg-btn dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
												<?php echo e(__('My Account')); ?>

											</a>
											<ul class="dropdown-menu">

												<?php if(Auth::user()->is_instructor == 2): ?>
												<li>
													<a class="dropdown-item" href="<?php echo e(route('instructor-dashboard')); ?>">
														<?php echo e(__('Instructor Panel')); ?>

													</a>
												</li>
												<?php endif; ?>

												<li>
													<a class="dropdown-item <?php echo e(request()->path() == 'student/dashboard' ? 'active' : ''); ?>" href="<?php echo e(route('student-dashboard')); ?>" >
														<?php echo e(__('Dashboard')); ?>

													</a>
												</li>


												<li>
													<a class="dropdown-item <?php echo e(request()->path() == 'student/profile' ? 'active' : ''); ?>" href="<?php echo e(route('student-profile')); ?>" >
														<?php echo e(__('Profile')); ?>

													</a>
												</li>

												<li>
													<a class="dropdown-item <?php echo e(request()->path() == 'student/account' ? 'active' : ''); ?>" href="<?php echo e(route('student-account')); ?>" >
														<?php echo e(__('Reset Password')); ?>

													</a>
												</li>

												<li>
													<a class="dropdown-item" href="<?php echo e(route('student-logout')); ?>">
														<?php echo e(__('Logout')); ?>

													</a>
												</li>

											</ul>
										</li>
									<?php else: ?> 

									<li class="nav-item">
										<a class="nav-link log-reg-btn" href="<?php echo e(route('student.login')); ?>"><?php echo e(__('Login/Register')); ?></a>
									</li>


									<?php endif; ?>
                                <?php else: ?>

								<li class="nav-item">
									<a class="nav-link log-reg-btn" href="<?php echo e(route('student.login')); ?>"><?php echo e(__('Login/Register')); ?></a>
								</li>

                                <?php endif; ?>
							</ul>
						</div>

					</nav>
				</div>
			</div>
		</div>
	</div>
	<!--Main-Menu Area Start-->

	<?php echo $__env->yieldContent('content'); ?>
	<!-- Footer Area Start -->
	<footer class="footer" id="footer">
		<div class="container">

			<div class="row">
				<div class="col-lg-12">
					<div class="top-links">
						<ul>
							<li>

								<?php if(Auth::check()): ?>
									<a href="<?php echo e(route('student-instructor-application')); ?>" ><?php echo e(__('Start Teaching Today')); ?></a>
								<?php else: ?>
									<a href="javascript:;"   data-toggle="modal" data-target="#bcomeinstructormodal">
										<?php echo e(__('Become An Instructor')); ?>

									</a>
								<?php endif; ?>

                            </li>

							<li>
								<a href="<?php echo e(route('front.blog')); ?>"><?php echo e(__('Blog')); ?></a>
							</li>

							<?php $__currentLoopData = DB::table('pages')->whereRegisterId(0)->whereStatus(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<li>
									<a href="<?php echo e(route('front.page',$page->slug)); ?>"><?php echo e($page->title); ?></a>
								</li>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


							<li>
								<?php if(DB::table('generalsettings')->where('register_id',0)->first()->is_contact==1): ?>
									<a href="<?php echo e(route('front.contact')); ?>"><?php echo e(__('Contact Us')); ?></a>
								<?php endif; ?>
							</li>

							<li>
								<div class="global-language">
									<select class="language">
										<?php $__currentLoopData = DB::table('languages')->where('register_id',0)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e(route('front.language',$language->id)); ?>" <?php echo e(Session::has('language') ? ( Session::get('language') == $language->id ? 'selected' : '' ) : (DB::table('languages')->where('register_id',0)->where('is_default','=',1)->first()->id == $language->id ? 'selected' : '')); ?>><?php echo e($language->language); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</li>
						</ul>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6 col-lg-7">
					<div class="footer-widget about-widget">
						<div class="footer-logo">
							<a href="#">
								<img src="<?php echo e(asset('assets/images/'.$gs->footer_logo)); ?>" alt="gooter_logo">
							</a>
							<p><?php echo $gs->copyright; ?></p>

						</div>
					</div>
				</div>
				<div class="col-md-6  col-lg-5">
					<div class="footer-widget  footer-newsletter-widget">
						<h4 class="title">
							<?php echo e(__('Newsletter')); ?>

						</h4>
						<div class="newsletter-form-area">
                            <form action="<?php echo e(route('front.subscribe')); ?>" id="subscribeform" method="POST">
                                <?php echo e(csrf_field()); ?>

								<input type="email" name="email" placeholder="<?php echo e(__('Your Email Address...')); ?>" required>
								<button id="sub-btn" type="submit">
									<i class="far fa-paper-plane"></i>
								</button>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</footer>
	<!-- Footer Area End -->

	<!-- Back to Top Start -->
	<div class="bottomtotop">
		<i class="fas fa-chevron-right"></i>
	</div>
	<!-- Back to Top End -->

	<!-- Become an instructor modal start -->

	<div class="modal fade" id="bcomeinstructormodal"  data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg">
		<div class="modal-content">
			<div class="modal-header">
			<h5 class="modal-title" id="staticBackdropLabel"><?php echo e(__('Become An Instructor')); ?></h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				<span aria-hidden="true">&times;</span>
			</button>
			</div>
			<div class="modal-body">
				<?php echo $__env->make('includes.admin.form-login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				<form id="registerform" action="<?php echo e(route('instructor-register-submit')); ?>" method="POST" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<div class="row">
					  <div class="col-md-6">
						<div class="form-group">
						  <label><?php echo e(__('First Name')); ?>:<sup class="text-danger">*</sup></label>
						  <input type="text" name="first_name" class="form-control" value="" required="">
						</div>
					  </div>
					  <div class="col-md-6">
						<div class="form-group">
						  <label><?php echo e(__('Last Name')); ?>:<sup class="text-danger">*</sup></label>
						  <input type="text" class="form-control" name="last_name"  value="" required="">
						</div>
					  </div>
					  </div>
					<div class="row">
					  <div class="col-md-6">
						<div class="form-group">
						  <label><?php echo e(__('Instructor Name')); ?>:<sup class="text-danger">*</sup></label>
						  <input type="text" class="form-control" name="instructor_name"  value="" required="">
						</div>
					  </div>
					  <div class="col-md-6">
						<div class="form-group">
						  <label><?php echo e(__('Email')); ?>:<sup class="text-danger">*</sup></label>
						  <input type="email" class="form-control" name="email"  value="" required="">
						</div>
					  </div>
					  </div>
					<div class="row">
					  <div class="col-md-6">
						<div class="form-group">
						  <label><?php echo e(__('Password')); ?>:<sup class="text-danger">*</sup></label>
						  <input type="password" value="" name="password" class="form-control" >
						</div>
					  </div>
					  <div class="col-md-6">
						<div class="form-group">
						  <label><?php echo e(__('Address')); ?>:<sup class="text-danger">*</sup></label>
						  <input type="text" name="address" class="form-control" value="" required="">
						</div>
					  </div>
					</div>
					<div class="row">
					  <div class="col-md-6">
						<div class="form-group">
						  <label><?php echo e(__('Phone')); ?>:<sup class="text-danger">*</sup></label>
						  <input type="text" value="" name="phone" class="form-control" >
						</div>
					  </div>
					  <div class="col-md-6">
						<div class="form-group">
						  <label><?php echo e(__('Any Message')); ?>:<sup class="text-danger"></sup></label>
						  <input type="text" name="message" class="form-control" value="" required="">
						</div>
					  </div>
					</div>

					<div class="row">
					  <div class="col-md-6">
						<?php if($gs->is_capcha == 1): ?>
                        <ul class="captcha-area">
                          <li>
                            <p><img class="codeimg1" src="<?php echo e(asset("assets/images/capcha_code.png")); ?>" alt=""></p>
                          </li>
                        </ul>

                        <div class="form-input d-flex mb-3">
                          <input type="text" class="form-control" name="codes" placeholder="<?php echo e(__('Enter Code')); ?>" autocomplete="off" required="">
                          <i class="fas fa-redo p-2 refresh_code"></i>
                        </div>
                        <?php endif; ?>
					  </div>

					  <div class="col-md-6">
						<div class="form-group">
							<label><?php echo e(__('Upload Document')); ?>:<sup class="text-danger">*</sup></label>
							<input type="file" name="document" >
						  </div>
					  </div>

					</div>

					<div class="box-footer">
					 <button type="submit" class="mybtn1"><?php echo e(__('Submit')); ?></button>
					</div>
				</form>
			</div>
		</div>
		</div>
	</div>

	<!-- Become an instructor modal End -->
	<script>

       	var capchaurl = "<?php echo e(url('/')); ?>";

        var mainurl = "<?php echo e(url('/')); ?>";

        var gs      = <?php echo json_encode(DB::table('generalsettings')->where('id','=',1)->first(['is_loader'])); ?>;

        var langg = {
            'cart_already'   : '<?php echo e(__('Already Added To Cart.')); ?>',
			'add_cart'       : '<?php echo e(__('Successfully Added To Cart.')); ?>',
            'add_wish'   	 : '<?php echo e(__('Successfully Added To Wishlist.')); ?>',
			'already_wish'   : '<?php echo e(__('Already Added To Wishlist.')); ?>',
			'wish_remove'    : '<?php echo e(__('Successfully Removed From Wishlist.')); ?>',
            'cart_empty'     : '<?php echo e(__('Cart is empty.')); ?>',
            'authenticating' : '<?php echo e(__('Authenticating')); ?>',
            'processing'     : '<?php echo e(__('Processing')); ?>',
            'checking'       : '<?php echo e(__('Checking')); ?>',
            'affiliate_link_copy': '<?php echo e(__('Affiliate Link Copied Successfully')); ?>'

        };

	</script>

	<!-- jquery -->
	<script src="<?php echo e(asset('assets/front/js/jquery.js')); ?>"></script>
	<!-- popper -->
    <script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
	<!-- bootstrap -->
	<script src="<?php echo e(asset('assets/front/js/bootstrap.min.js')); ?>"></script>
    <!-- plugin js-->
	<script src="<?php echo e(asset('assets/front/js/plugin.js')); ?>"></script>
	
	<script src="<?php echo e(asset('assets/front/js/toastr.js')); ?>"></script>
	<!-- custom js-->
	<script src="<?php echo e(asset('assets/front/js/custom.js')); ?>"></script>
	<!-- main -->
	<script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>

	<?php echo $__env->yieldContent('scripts'); ?>
	<script>
		$(document).ready(function(){
			$('.refresh_code').click();
		})
	</script>

	<?php if(session()->has('success')): ?>
    <script>
       toastr.success("<?php echo e(__(session('success'))); ?>");
    </script>
    <?php endif; ?>

    <?php if(session()->has('error')): ?>
    <script>
       toastr.error("<?php echo e(__(session('error'))); ?>");
    </script>
    <?php endif; ?>

</body>

</html>
<?php /**PATH /home/royaldem/public_html/project/resources/views/layouts/front.blade.php ENDPATH**/ ?>