<?php $__env->startSection('content'); ?>
<div class="card">
  <div class="d-sm-flex align-items-center justify-content-between">
  <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Instructor Application')); ?> </h5>
  <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="<?php echo e(route('student-dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
      <li class="breadcrumb-item"><a href="<?php echo e(route('student-instructor-application')); ?>"><?php echo e(__('Instructor Application')); ?></a></li>
  </ol>
  </div>
</div>

<div class="row justify-content-center mt-3">
<div class="col-lg-12">
  <!-- Form Basic -->
  <div class="card mb-4">
    <div class="card-header px-5 d-flex flex-row align-items-center justify-content-between">
      <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Instructor Application')); ?></h6>
    </div>

    <div class="card-body px-5">
      <?php if($user->is_instructor != 1): ?>
      <div class="gocover" style="background: url(<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
      <form class="geniusform" action="<?php echo e(route('student-instructor-application.submit')); ?>" method="POST" enctype="multipart/form-data">

          <?php echo $__env->make('includes.admin.form-both', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

          <?php echo e(csrf_field()); ?>


        <div class="form-group">
            <label for="name"><?php echo e(__('Instructor Name')); ?></label>
            <input type="text" class="form-control" id="name" name="instructor_name"  placeholder="<?php echo e(__('Instructor Name')); ?>" value="" required>
        </div>


          <div class="form-group">
              <label for="address"><?php echo e(__('Address')); ?></label>
              <textarea class="form-control"  id="address" name="address" required rows="3" placeholder="<?php echo e(__('Address')); ?>"></textarea>
          </div>

        <div class="form-group">
            <label for="phone"><?php echo e(__('Phone')); ?></label>
            <input type="text" class="form-control" id="phone" name="phone"  placeholder="<?php echo e(__('Phone')); ?>" value="" required>
        </div>

        <div class="form-group">
            <label for="message"><?php echo e(__('Any message')); ?></label>
            <textarea class="form-control"  id="message" name="message" rows="3" placeholder="<?php echo e(__('Message')); ?>"></textarea>
        </div>


        <div class="form-group">
            <label for="document"><?php echo e(__('Document')); ?></label>
            <input type="file" class="form-control" id="document" name="document"  placeholder="<?php echo e(__('Document')); ?>" value="">
            <p><?php echo e(__('If any document you want to share ( .doc, .docs, .pdf, .txt, .png, .jpg, jpeg ) Are accepted')); ?></p>
        </div>

          <button type="submit" id="submit-btn" class="btn btn-primary"><?php echo e(__('Submit')); ?></button>

      </form>
      <?php else: ?>
      <div class="alert alert-success validation" style="">
        <p class="text-left">
          <div class="text-center"><i class="fas fa-check-circle fa-4x"></i><br>
            <h3><?php echo e(__('Your Documents Submitted Successfully.')); ?></h3>
          </div>
        </p>
      </div>
      <?php endif; ?>
    </div>
  </div>

  <!-- Form Sizing -->

  <!-- Horizontal Form -->

</div>

</div>
<!--Row-->


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>

$("#seo").change(function() {
    if(this.checked) {
        $('.showbox').removeClass('d-none');
    }else{
        $('.showbox').addClass('d-none');
    }
});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/instructor/application.blade.php ENDPATH**/ ?>