<?php $__env->startSection('content'); ?>


<!--Main Breadcrumb Area Start -->
<div class="main-breadcrumb-area" style="background-image: url(<?php echo e($gs->breadcumb_banner ? asset('assets/images/'.$gs->breadcumb_banner):asset('assets/images/noimage.png')); ?>);">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <ul class="pages">
          <li>
            <a href="<?php echo e(route('front.index')); ?>">
              <?php echo e(__('Home')); ?>

            </a>
          </li>
          <li>
            <a href=" <?php echo e(route('front.blog')); ?> ">
              <?php echo e(__('Blog')); ?>

            </a>
          </li>
        </ul>
      </div>
    </div>
  </div>
</div>
<!--Main Breadcrumb Area End -->

<!-- Blog Area Start -->
<section class="blog blog-page" id="blog">
  <div class="container">
    <div class="row">
      <div class="col-lg-8" id="ajaxContent">

        <div class="row">

          <?php if(count($blogs) > 0): ?>

            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <div class="col-md-6">
              <a href="<?php echo e(route('front.blogshow',$blog->id)); ?>" class="single-blog">
                <div class="img">
                  <img src="<?php echo e(asset('assets/images/blogs/'.$blog->photo)); ?>" alt="blog-photo">
                </div>
                <div class="content">
                  <span>
                    <h4 class="title">
                      <?php echo e($blog->title); ?>

                    </h4>
                  </span>
                  <div class="text">
                    <p>
                      <?php echo e(substr(strip_tags($blog->details),0,170)); ?>

                    </p>
                  </div>

                  <ul class="top-meta">
                    <li>
                      <span>
                        <i class="far fa-clock"></i><?php echo e(\Carbon\Carbon::parse($blog->created_at)->diffForHumans()); ?>

                      </span>
                    </li>

                  </ul>
                </div>
              </a>
            </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php else: ?>
            <?php echo e(__('No Blog Found')); ?>

          <?php endif; ?>

        </div>

        <div class="page-center">
          <?php if(isset($_GET['search'])): ?>
            <?php echo $blogs->appends(['search' => $_GET['search']])->links(); ?>   
          <?php else: ?>
            <?php echo $blogs->links(); ?>   
          <?php endif; ?> 
        </div>
      </div>
      <div class="col-lg-4">
        <div class="blog-aside">
          <div class="serch-widget">
            <h4 class="title">
              <?php echo e(__('Search')); ?>

            </h4>
            <form action="<?php echo e(route('front.blogsearch')); ?>" method="get">
              <input type="text" name="search" placeholder="<?php echo e(__('Search Content')); ?>">
              <button class="submit" type="submit"><?php echo e(__('Search')); ?></button>
            </form>
          </div>
          <div class="categori">
            <h4 class="title"><?php echo e(__('Categories')); ?></h4>
            <ul class="categori-list">
              <?php $__currentLoopData = $bcat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li>
                <a href="<?php echo e(route('front.blogcategory',[$cat->slug,$cat->id])); ?>">
                  <span><?php echo e($cat->name); ?></span>
                  <span><?php echo e($cat->blogs->count()); ?></span>
                </a>
              </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </ul>
          </div>
          <div class="recent-post-widget">
            <h4 class="title"><?php echo e(__('Recent Post')); ?></h4>
            <ul class="post-list">
              <?php $__currentLoopData = App\Models\Blog::orderBy('created_at', 'desc')->where('register_id',0)->limit(4)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li>
                  <div class="post">
                      <div class="post-img">
                          <img style="width: 73px; height: 59px;" src="<?php echo e(asset('assets/images/blogs/'.$blog->photo)); ?>" alt="blog-image">
                      </div>
                      <div class="post-details">
                          <a href="<?php echo e(route('front.blogshow',$blog->id)); ?>">
                              <h4 class="post-title">
                                  <?php echo e(strlen($blog->title) > 45 ? substr($blog->title,0,45)." .." : $blog->title); ?>

                              </h4>
                          </a>
                          <p class="date">
                              <?php echo e(date('M d - Y',(strtotime($blog->created_at)))); ?>

                          </p>
                      </div>
                  </div>
              </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>

          <div class="tags">
            <h4 class="title"><?php echo e(__('Tags')); ?></h4>
            <span class="separator"></span>
            <ul class="tags-list">
              <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(!empty($tag)): ?>
                      <li>
                          <a href="<?php echo e(route('front.blogtags',$tag)); ?>"><?php echo e($tag); ?> </a>
                      </li>
                <?php endif; ?> 
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Blog Area End-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/front/blog.blade.php ENDPATH**/ ?>