<?php $__env->startSection('content'); ?>

<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800"><?php echo e(__('Dashboard')); ?></h1>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    </ol>
  </div>

  <div class="row mb-3">

    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-body">
          <div class="row align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Courses')); ?></div>
              <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(\DB::table('courses')->whereRegisterId(0)->whereStatus(1)->count()); ?></div>
            </div>
            <div class="col-auto">
              <i class="fas fa-graduation-cap fa-2x text-primary"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-body">
          <div class="row no-gutters align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Students')); ?></div>
              <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(\DB::table('users')->whereRegisterId(0)->where('is_instructor','!=',2)->whereStatus(1)->count()); ?></div>
            </div>
            <div class="col-auto">
              <i class="fas fa-user-graduate fa-2x text-success"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-body">
          <div class="row no-gutters align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Instructors')); ?></div>
              <div class="h5 mb-0 mr-3 font-weight-bold text-gray-800"><?php echo e(\DB::table('users')->whereRegisterId(0)->where('is_instructor','=',2)->whereStatus(1)->count()); ?></div>
            </div>
            <div class="col-auto">
              <i class="fas fa-user-tie fa-2x text-info"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-body">
          <div class="row no-gutters align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Posts')); ?></div>
              <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(\DB::table('blogs')->whereRegisterId(0)->count()); ?></div>
            </div>
            <div class="col-auto">
              <i class="fas fa-comments fa-2x text-warning"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Area Chart -->
    <div class="col-xl-12 col-lg-12">
      <div class="card mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
          <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Total Sales in Last 30 Days')); ?></h6>

        </div>
        <div class="card-body">
          <div class="chart-area">
            <canvas id="lineChart"></canvas>
          </div>
        </div>
      </div>
    </div>



  </div>
  <!--Row-->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>


<script type="text/javascript">
    
    displayLineChart();

    function displayLineChart() {
        var data = {
            labels: [
            <?php echo $days; ?>

            ],
            datasets: [{
                label: "Prime and Fibonacci",
                fillColor: "#3dbcff",
                strokeColor: "#0099ff",
                pointColor: "rgba(220,220,220,1)",
                pointStrokeColor: "#fff",
                pointHighlightFill: "#fff",
                pointHighlightStroke: "rgba(220,220,220,1)",
                data: [
                <?php echo $sales; ?>

                ]
            }]
        };
        var ctx = document.getElementById("lineChart").getContext("2d");
        var options = {
            responsive: true
        };
        var lineChart = new Chart(ctx).Line(data, options);
    }

</script>
  

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>