<?php $__env->startSection('content'); ?>
	<!-- Hero Area Start -->
	<section class="hero-area">
		<div class="intro-content" style="background-image: url(<?php echo e($ps->hero_bg ? asset('assets/images/'.$ps->hero_bg) : ''); ?>)">
			<div class="container">
				<div class="row">
					<div class="col-lg-12">
						<div class="slider-content">
							<!-- layer 1 -->
							<div class="layer-1">
								<h2 class="title"><?php echo e(__('GLearn on your schedule')); ?></h2>
							</div>
							<!-- layer 2 -->
							<div class="layer-2">
								<p class="text">
									<?php echo e(__('Anywhere, anytime. Start learning today!')); ?>

								</p>
							</div>
							<!-- layer 3 -->
							<div class="layer-3">
								<div class="serch-form2">
									<form action="<?php echo e(route('front.catalog', [Request::route('category'),Request::route('subcategory')])); ?>" method="GET">
										<input name="search" type="text" placeholder="<?php echo e(__('What do you want to learn ?')); ?>" required>
										<button type="submit">
											<i class="fas fa-search"></i>
										</button>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Hero Area End -->

	<!-- Feature Area Start -->
	<section class="feature-section">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<div class="feature-section-inner">
						<div class="row">
							<?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<div class="col-lg-4">
								<div class="single-feature">
									<div class="left-icon">
										<img src="<?php echo e(asset('assets/images/services/'.$service->photo)); ?>" alt="service">
									</div>
									<div class="right-content">
										<h4 class="title"><?php echo e($service->title); ?></h4>
										<p><?php echo e($service->details); ?>s</p>
									</div>
								</div>
							</div>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Feature Area End -->

	<!-- Tab Product Area Start  -->
	<section class="tab-product-section">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<div class="top-heading-area">
						<h4 class="title">
							<?php echo e(__("The world's largest selection of courses")); ?>

						</h4>
						<p>
							<?php echo e(__("Choose from 100,000 online video courses with new additions published every month")); ?>

						</p>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-12">
					<div class="product-tabs">
						<ul class="nav" role="tablist">

							<?php $__currentLoopData = DB::table('categories')->whereRegisterId(0)->whereStatus(1)->whereIsTop(1)->take(6)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

							<li class="nav-item" role="presentation">
								<a class="nav-link <?php echo e($loop->first ? 'active' : ''); ?>" id="pills-<?php echo e($tcat->slug); ?>-tab" data-toggle="pill" href="#pills-<?php echo e($tcat->slug); ?>" role="tab" aria-controls="pills-<?php echo e($tcat->slug); ?>" aria-selected="true">
									<?php echo e($tcat->name); ?>

								</a>
							</li>

							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

						</ul>

						  <div class="tab-content" id="pills-tabContent">

							<?php $__currentLoopData = \App\Models\Category::whereRegisterId(0)->whereStatus(1)->whereIsTop(1)->take(6)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

							<div class="tab-pane fade <?php echo e($loop->first ? 'show active' : ''); ?>" id="pills-<?php echo e($topcat->slug); ?>" role="tabpanel" aria-labelledby="pills-<?php echo e($topcat->slug); ?>-tab">
								<div class="slick-product-slider">
									
								<?php $__currentLoopData = $topcat->courses()->whereRegisterId(0)->whereStatus(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $top_course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

									<div class="slider-item">
										<div class="single-course">
											<div class="img">
												<img src="<?php echo e(asset('assets/images/courses/'.$top_course->photo)); ?>" alt="course">
											</div>
											<div class="content">
												<p class="author">


													<a href="<?php echo e(!empty($top_course->instructor) ? route('instructor.details',$top_course->instructor->instructor_slug) : route('instructor.details',DB::table('admins')->first()->slug)); ?>">
														<?php echo e(!empty($top_course->instructor) ? $top_course->instructor->instructor_name : DB::table('admins')->first()->name); ?>

													  </a>

												</p>

												<a href="<?php echo e(route('front.course',$top_course->slug)); ?>">
													<h4 class="title">
														<?php echo e($top_course->showTitle()); ?>

													</h4>
												</a>

												<?php if(App\Models\Rating::normalRating($top_course->id) != 0): ?>
												<div class="reating-area">
												  <span class="number"><?php echo e(App\Models\Rating::normalRating($top_course->id)); ?></span>
												  <div class="stars">
													  <div class="ratings">
														  <div class="empty-stars"></div>
														  <div class="full-stars" style="width:<?php echo e(App\Models\Rating::ratings($top_course->id)); ?>%"></div>
														</div>
												  </div>
												  <div class="total-star">
													(<?php echo e(App\Models\Rating::ratingCount($top_course->id)); ?>)
												  </div>
												</div>
                                                <?php endif; ?>
                                                <?php if($top_course->price == 0): ?>
                                                    <?php echo e(__('Free')); ?>

                                                <?php else: ?>
                                                    <p class="price">
                                                        <?php echo e($curr->sign); ?><?php echo e($top_course->price); ?> <del><?php echo e($curr->sign); ?><?php echo e($top_course->discount_price); ?></del>
                                                    </p>
                                                <?php endif; ?>
											</div>
										</div>
									</div>

								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

								</div>
							</div>

							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

						  </div>

					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Tab Product Area End -->

	<!-- Product Area Start -->
	<section class="product-section">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<div class="section-heading">
						<h2 class="title"><?php echo e(__('Top Courses')); ?>

						</h2>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-12">
					<div class="product-slider">
						<?php $__currentLoopData = $top_courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="single-slider">
							<div class="single-course">
								<div class="img">
									<img src="<?php echo e(asset('assets/images/courses/'.$course->photo)); ?>" alt="course">
								</div>
								<div class="content">
									<p class="author">
										<a href="<?php echo e(!empty($course->instructor) ? route('instructor.details',$course->instructor->instructor_slug) : route('instructor.details',DB::table('admins')->first()->slug)); ?>">
										  <?php echo e(!empty($course->instructor) ? $course->instructor->instructor_name : DB::table('admins')->first()->name); ?>

										</a>
									  </p>

                                    <a href="<?php echo e(route('front.course',$course->slug)); ?>">
										<h4 class="title">
											<?php echo e($course->showTitle()); ?>

                                        </h4>
                                    </a>

									<?php if(App\Models\Rating::normalRating($course->id) != 0): ?>
									<div class="reating-area">
									  <span class="number"><?php echo e(App\Models\Rating::normalRating($course->id)); ?></span>
									  <div class="stars">
										  <div class="ratings">
											  <div class="empty-stars"></div>
											  <div class="full-stars" style="width:<?php echo e(App\Models\Rating::ratings($course->id)); ?>%"></div>
											</div>
									  </div>
									  <div class="total-star">
										(<?php echo e(App\Models\Rating::ratingCount($course->id)); ?>)
									  </div>
									</div>
									<?php endif; ?>
									<?php if($course->price == 0): ?>

									<p class="price">
									  <?php echo e(__('Free')); ?>

									</p>

									<?php else: ?>

									<p class="price">
										<?php echo e($curr->sign); ?><?php echo e(round(($course->price * $curr->value),2)); ?> <del><?php echo e($curr->sign); ?><?php echo e(round(($course->discount_price * $curr->value),2)); ?></del>
									</p>

									<?php endif; ?>
								</div>
							</div>
						</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Product Area End -->

	<!-- Product Area Start -->
	<section class="product-section pb-70">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<div class="section-heading">
						<h2 class="title"><?php echo e(__('New Courses')); ?>

						</h2>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-12">
					<div class="product-slider">
						<?php $__currentLoopData = $new_courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="single-slider">
							<div class="single-course">
								<div class="img">
									<img src="<?php echo e(asset('assets/images/courses/'.$course->photo)); ?>" alt="course">
								</div>
								<div class="content">
									<p class="author">
										<a href="<?php echo e(!empty($course->instructor) ? route('instructor.details',$course->instructor->instructor_slug) : route('instructor.details',DB::table('admins')->first()->slug)); ?>">
										  <?php echo e(!empty($course->instructor) ? $course->instructor->instructor_name : DB::table('admins')->first()->name); ?>

										</a>
									  </p>
                                    <a href="<?php echo e(route('front.course',$course->slug)); ?>">
										<h4 class="title">
											<?php echo e($course->showTitle()); ?>

										</h4>
                                    </a>

									<?php if(App\Models\Rating::normalRating($course->id) != 0): ?>
									<div class="reating-area">
									  <span class="number"><?php echo e(App\Models\Rating::normalRating($course->id)); ?></span>
									  <div class="stars">
										  <div class="ratings">
											  <div class="empty-stars"></div>
											  <div class="full-stars" style="width:<?php echo e(App\Models\Rating::ratings($course->id)); ?>%"></div>
											</div>
									  </div>
									  <div class="total-star">
										(<?php echo e(App\Models\Rating::ratingCount($course->id)); ?>)
									  </div>
									</div>
									<?php endif; ?>
									<?php if($course->price == 0): ?>

									<p class="price">
									  <?php echo e(__('Free')); ?>

									</p>

									<?php else: ?>

									<p class="price">
										<?php echo e($curr->sign); ?><?php echo e(round(($course->price * $curr->value),2)); ?> <del><?php echo e($curr->sign); ?><?php echo e(round(($course->discount_price * $curr->value),2)); ?></del>
									</p>

									<?php endif; ?>
								</div>
							</div>
						</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Product Area End -->

	<!-- Categories Area Start -->
	<section class="category-section pb-70">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<div class="section-heading">
						<h2 class="title"><?php echo e(__('Top Categories')); ?>

						</h2>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-12">
					<ul class="category-list">
						<?php $__currentLoopData = DB::table('categories')->whereRegisterId(0)->whereStatus(1)->whereIsTop(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<li>
							<a href="<?php echo e(route('front.catalog',[$topcat->slug])); ?>">
								<img src="<?php echo e(asset('assets/images/categories/'.$topcat->photo)); ?>" alt=""><?php echo e($topcat->name); ?>

							</a>
						</li>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</ul>
				</div>
			</div>
		</div>
	</section>
	<!-- Categories Area End -->

	<!-- Become Author Area Start -->
	<section class="become-author-section pb-70">
		<div class="container">
			<div class="row">
				<div class="col-lg-6 col-md-6">
					<?php if($ps->instructor_img): ?>
					<div class="left-img">
						<img src="<?php echo e(asset('assets/images/'.$ps->instructor_img)); ?>" alt="">
					</div>
					<?php endif; ?>
				</div>
				<div class="col-lg-6 col-md-6 align-self-center">
					<div class="content">
						<h4 class="title">
							<?php echo e(__('Become an instructor')); ?>

						</h4>
						<p>
						    <?php echo e(__('Lorem ipsum dolor sit amet, consectetur adipisicing elit. Sed velit officiis accusamus tenetur totam magnam sunt eveniet quos porro dignissimos neque, quaerat tempora nostrum.')); ?>

						</p>
						<?php if(Auth::check()): ?>
							<a href="<?php echo e(route('student-instructor-application')); ?>" class="mybtn1"><?php echo e(__('Start Teaching Today')); ?></a>
						<?php else: ?>
							<a href="javascript:;" class="mybtn1"  data-toggle="modal" data-target="#bcomeinstructormodal">
								<?php echo e(__('Become An Instructor')); ?>

							</a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Become Author Area End -->

	<!-- Blog Area Start -->
	 <section class="blog pb-70">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<div class="section-heading">
						<h2 class="title">
							<?php echo e(__('Our Blogs')); ?>

						</h2>
					</div>
				</div>
			</div>
			<div class="row justify-content-center">
				<?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<div class="col-lg-4 col-md-6">
					<a href="<?php echo e(route('front.blogshow',$blog->id)); ?>" class="single-blog">
						<div class="img">
							<img src="<?php echo e(asset('assets/images/blogs/'.$blog->photo)); ?>" alt="blog-photo">
						</div>
						<div class="content">
							<span>
								<h4 class="title">
									<?php echo e($blog->title); ?>

								</h4>
							</span>
							<div class="text">
								<p>
									<?php echo e(substr(strip_tags($blog->details),0,170)); ?>

								</p>
							</div>

							<ul class="top-meta">
								<li>
									<span>
										<i class="far fa-clock"></i><?php echo e(\Carbon\Carbon::parse($blog->created_at)->diffForHumans()); ?>

									</span>
								</li>

							</ul>
						</div>
					</a>
				</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>
			<?php if($blogs->count()>0): ?>
				<div class="row">
					<div class="col-lg-12 text-center">
						<a href="<?php echo e(route('front.blog')); ?>" class="view-all-btn"><?php echo e(__('View All')); ?></a>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</section>
	<!-- Blog Area End -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/front/index.blade.php ENDPATH**/ ?>