<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Messages')); ?></h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('instructor-dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
            <li class="breadcrumb-item"><a href="javascript:;"><?php echo e(__('Messages')); ?></a></li>
        </ol>
        </div>
    </div>


    <!-- Row -->
    <div class="row mt-3">
      <!-- Datatables -->
      <div class="col-lg-12">

        <?php echo $__env->make('includes.admin.form-success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="card mb-4">
          <div class="table-responsive p-3">
            <table class="table align-items-center table-flush" id="geniustable">
              <thead class="thead-light">
                <tr>
                  <th><?php echo e(__('Name')); ?></th>
                  <th><?php echo e(__('Message')); ?></th>
                  <th><?php echo e(__('Send')); ?></th>
                  <th><?php echo e(__('Options')); ?></th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $convs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                  <tr class="conv">
                    <input type="hidden" value="<?php echo e($conv->id); ?>">
                    <?php if($user->id == $conv->sent->id): ?>
                    <td><?php echo e($conv->recieved->first_name . $conv->recieved->last_name); ?></td>
                    <?php else: ?>
                    <td><?php echo e($conv->sent->first_name  . $conv->sent->last_name); ?></td>
                    <?php endif; ?>
                    <td><?php echo e($conv->subject); ?></td>
                    <td><?php echo e($conv->created_at->diffForHumans()); ?></td>
                    <td>
                      <a href="<?php echo e(route('instructor-message',$conv->id)); ?>" class="btn btn-primary view"><i class="fa fa-eye"></i></a>
                      <a href="javascript:;" data-toggle="modal" data-target="#confirm-delete" data-href="<?php echo e(route('instructor-message-delete',$conv->id)); ?>" class="btn btn-danger remove"><i class="fa fa-trash"></i></a>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            </table>
          </div>
        </div>
      </div>
      <!-- DataTable with Hover -->

    </div>
    <!--Row-->


<div class="message-modal">
    <div class="modal" id="vendorform" tabindex="-1" role="dialog" aria-labelledby="vendorformLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="vendorformLabel"><?php echo e(__('Send Message')); ?></h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
          </div>
        <div class="modal-body">
          <div class="container-fluid p-0">
            <div class="row">
              <div class="col-md-12">
                <div class="contact-form">
                  <form id="emailreply">
                    <?php echo e(csrf_field()); ?>

                    <ul class="mylists">

                      <li>
                        <input type="email" class="input-field" id="eml" name="email" placeholder="<?php echo e(__('Email')); ?> *" required="">
                      </li>
                      <li>
                        <input type="text" class="input-field" id="subj" name="subject" placeholder="<?php echo e(__('Subject')); ?> *" required="">
                      </li>

                      <li>
                        <textarea class="input-field textarea" name="message" id="msg" placeholder="<?php echo e(__('Your Message')); ?> *" required=""></textarea>
                      </li>

                      <input type="hidden" name="name" value="<?php echo e(Auth::guard('web')->user()->name); ?>">
                      <input type="hidden" name="user_id" value="<?php echo e(Auth::guard('web')->user()->id); ?>">

                    </ul>
                    <button class="btn btn-success" id="emlsub" type="submit"><?php echo e(__('Send Message')); ?></button>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
        </div>
      </div>
    </div>
  </div>

  




<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="modal1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">

    <div class="modal-header d-block text-center">
        <h4 class="modal-title d-inline-block"><?php echo e(__('Confirm Delete')); ?></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
    </div>
                <div class="modal-body">
            <p class="text-center"><?php echo e(__('You are about to delete this Conversation.')); ?></p>
            <p class="text-center"><?php echo e(__('Do you want to proceed?')); ?></p>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Cancle')); ?></button>
                    <a class="btn btn-danger btn-ok"><?php echo e(__('Delete')); ?></a>
                </div>
            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">

var table = $('#geniustable').DataTable();
$(function() {
            $(".btn-area").append('<div class="col-sm-12 col-md-4 text-right">'+
                                    '<a class="btn btn-primary"  data-toggle="modal" data-target="#vendorform" href="javascript:;"><?php echo e(__("Compose Message")); ?></a>'+
                            '</div>');
        });

</script>

<script type="text/javascript">

    $(document).on("submit", "#emailreply" , function(){
    var token = $(this).find('input[name=_token]').val();
    var subject = $(this).find('input[name=subject]').val();
    var message =  $(this).find('textarea[name=message]').val();
    var email = $(this).find('input[name=email]').val();
    var name = $(this).find('input[name=name]').val();
    var user_id = $(this).find('input[name=user_id]').val();
    $('#eml').prop('disabled', true);
    $('#subj').prop('disabled', true);
    $('#msg').prop('disabled', true);
    $('#emlsub').prop('disabled', true);
$.ajax({
      type: 'post',
      url: "<?php echo e(route('instructor-contact')); ?>",
      data: {
          '_token': token,
          'subject'   : subject,
          'message'  : message,
          'email'   : email,
          'name'  : name,
          'user_id'   : user_id
            },
      success: function( data) {
    $('#eml').prop('disabled', false);
    $('#subj').prop('disabled', false);
    $('#msg').prop('disabled', false);
    $('#subj').val('');
    $('#msg').val('');
    $('#emlsub').prop('disabled', false);
  if(data == 0)
    toastr.error("<?php echo e(__('Email Not Found')); ?>");
  else
    toastr.success("<?php echo e(__('Message Sent Successfully.')); ?>");

  $('.close').click();
  }
  });
    return false;
  });

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/instructor/message/index.blade.php ENDPATH**/ ?>