
<!DOCTYPE html>
<html lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

	<title><?php echo e($gs->title); ?></title>

	<!-- favicon -->
	<link rel="shortcut icon" href="<?php echo e(asset('assets/images/'.$gs->favicon)); ?>" type="image/x-icon">
	<!-- bootstrap -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>">
	<!-- Plugin css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/plugin.css')); ?>">
    <!-- Toastr css -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/toastr.css')); ?>">
	<!-- stylesheet -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/style.css')); ?>">
	<!-- responsive -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/responsive.css')); ?>">

</head>

<body class="py-5">


    <?php if($gs->is_loader == 1): ?>
	    <div class="preloader" id="preloader" style="background: url(<?php echo e(asset('assets/images/'.$gs->loader)); ?>)"></div>
    <?php endif; ?>

<div class="container checkout">
	<div class="row justify-content-center mb-5">
		<div class="col-md-8">
			<div class="row">
				<div class="col-md-12">
					<span class="payment-header-text float-left"><b><?php echo e(__('Make payment')); ?></b></span>
					<a href="<?php echo e(route('front.cart')); ?>" class="close-btn-light float-right"><i class="fa fa-times"></i></a>
				</div>
			</div>
		</div>
	</div>

	<div class="row justify-content-center">
		<div class="col-md-8">
			<div class="row">
				<div class="col-md-3">
					<p class="pb-2 payment-header"><?php echo e(__('Payment Gateway')); ?></p>
                        <?php if($paypal->status == 1): ?>
                            <div class="row payment-gateway paypal">
                                <div class="col-12">
                                    <img class="tick-icon paypal-icon d-none" src="<?php echo e(asset('assets/images/tick.png')); ?>">
                                    <img class="payment-gateway-icon" data-title="paypal" src="<?php echo e(asset('assets/images/'.$paypalData['photo'])); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if($stripe->status == 1): ?>
                            <div class="row payment-gateway stripe">
                                <div class="col-12">
                                    <img class="tick-icon stripe-icon d-none" src="<?php echo e(asset('assets/images/tick.png')); ?>">
                                    <img class="payment-gateway-icon" data-title="stripe" src="<?php echo e(asset('assets/images/'.$stripeData['photo'])); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
					<!--paystack payment gateway addon-->

				</div>

				<div class="col-md-1"></div>

				<div class="col-md-8">
					<div class="w-100">
                        <p class="pb-2 payment-header"><?php echo e(__('Order Summary')); ?></p>
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>



                            <p class="item float-left">
								<span class="count-item"><?php echo e($loop->index + 1); ?></span>
								<span class="item-title"><?php echo e($course['item']['title']); ?>

									<span class="item-price">
										<?php echo e($curr->sign); ?><?php echo e(round(($course['price'] * $curr->value),2)); ?>

									</span>
								</span>
								<span class="by-owner">
                                    <?php echo e(__('By')); ?> <?php echo e($course['instructor']); ?>

                                </span>
                            </p>



                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <?php if($discount != 0): ?>

					<div class="w-100 float-left mt-4 indicated-price pb-0">
						<div class="float-right total-price"><?php echo e($curr->sign); ?><?php echo e(round(($discount * $curr->value),2)); ?></div>
						<div class="float-right discount"><?php echo e(__('Discount')); ?></div>
					</div>

                    <?php endif; ?>

					<div class="w-100 float-left mt-4 indicated-price">
						<div class="float-right total-price"><?php echo e($curr->sign); ?><?php echo e(round(($totalPrice * $curr->value),2)); ?></div>
						<div class="float-right total"><?php echo e(__('Total')); ?></div>
					</div>
					<div class="w-100 float-left">
                        <?php if($paypal->status == 1): ?>
                            <form action="<?php echo e(route('paypal.submit')); ?>" method="post" class="checkoutform paypal-form form d-none">

                                <?php echo csrf_field(); ?>

                                <hr class="border mb-4">

                                <input type="hidden" name="discount" value="<?php echo e($discount); ?>">

                                <input type="hidden" name="method" value="<?php echo e($paypal->name); ?>">

                                <input type="hidden" name="pay_amount" value="<?php echo e($totalPrice); ?>">

                                <button type="submit" class="payment-button float-right"><?php echo e(__('Pay By Paypal')); ?></button>

                            </form>
                        <?php endif; ?>
                        <?php if($stripe->status == 1): ?>
                            <form action="<?php echo e(route('stripe.submit')); ?>" method="post" class="checkoutform stripe-form form d-none">

                                <?php echo csrf_field(); ?>

                                <hr class="border mb-4">

                                <input type="hidden" name="discount" value="<?php echo e($discount); ?>">

                                <input type="hidden" name="method" value="<?php echo e($stripe->name); ?>">

                                <input type="hidden" name="pay_amount" value="<?php echo e($totalPrice); ?>">

                                <div class="form-group">
                                    <input type="text" class="form-control" name="cardNumber"  placeholder="<?php echo e(__('Card Number')); ?>" required autocomplete="off"  autofocus oninput="validateCard(this.value);">
                                    <span class="d-block mt-2 text-danger" id="errCard"></span>
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" name="cardCVC"  placeholder="<?php echo e(__('Cvv')); ?>" required autocomplete="off"  oninput="validateCVC(this.value);">
                                    <span class="d-block mt-2 text-danger" id="errCVC"></span>
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" name="month"  placeholder="<?php echo e(__('Month')); ?>" required>
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" name="year"  placeholder="<?php echo e(__('Year')); ?>" required>
                                </div>
                                <button type="submit" class="payment-button float-right"><?php echo e(__('Pay By Stripe')); ?></button>

                            </form>
                        <?php endif; ?>
			        </div>
				</div>
			</div>
		</div>
	</div>
</div>

	<!-- Become an instructor modal End -->
	<script>

        var mainurl = "<?php echo e(url('/')); ?>";

        var gs      = <?php echo json_encode(DB::table('generalsettings')->where('id','=',1)->first(['is_loader'])); ?>;

        var langg = {
            'cart_already' : '<?php echo e(__('Already Added To Cart.')); ?>',
            'add_cart'     : '<?php echo e(__('Successfully Added To Cart.')); ?>',
            'cart_empty'   : '<?php echo e(__('Cart is empty.')); ?>'
        };

	</script>

	<!-- jquery -->
	<script src="<?php echo e(asset('assets/front/js/jquery.js')); ?>"></script>
	<!-- popper -->
    <script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
	<!-- bootstrap -->
	<script src="<?php echo e(asset('assets/front/js/bootstrap.min.js')); ?>"></script>
    <!-- plugin js-->
	<script src="<?php echo e(asset('assets/front/js/plugin.js')); ?>"></script>
	
	<script src="<?php echo e(asset('assets/front/js/toastr.js')); ?>"></script>
	<!-- custom js-->
	<script src="<?php echo e(asset('assets/front/js/custom.js')); ?>"></script>
	<!-- main -->
	<script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>


    <script type="text/javascript" src="<?php echo e(asset('assets/front/js/payvalid.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(asset('assets/front/js/paymin.js')); ?>"></script>
    
    <script type="text/javascript" src="<?php echo e(asset('assets/front/js/payform.js')); ?>"></script>

    <script type="text/javascript" src="https://js.stripe.com/v2/"></script>


    <script type="text/javascript">

        var cnstatus = false;
        var dateStatus = false;
        var cvcStatus = false;
                                  
        function validateCard(cn) {
          cnstatus = Stripe.card.validateCardNumber(cn);
          if (!cnstatus) {
            $("#errCard").html('<?php echo e(__("Card number not valid")); ?>');
          } else {
            $("#errCard").html('');
          }
        }
                                  
        function validateCVC(cvc) {
          cvcStatus = Stripe.card.validateCVC(cvc);
          if (!cvcStatus) {
            $("#errCVC").html('<?php echo e(__("CVC number not valid")); ?>');
          } else {
            $("#errCVC").html('');
          }
                
        }
                                  
      </script>

    
	<?php echo $__env->yieldContent('scripts'); ?>

	<?php if(session()->has('success')): ?>
    <script>
       toastr["success"]("<?php echo e(__(session('success'))); ?>");
    </script>
    <?php endif; ?>

    <?php if(session()->has('error')): ?>
    <script>
       toastr["error"]("<?php echo e(__(session('error'))); ?>");
    </script>
    <?php endif; ?>

    <script>

        $('.payment-gateway-icon').on('click',function(){
            var $this = $(this);
            $this.prev().removeClass('d-none');
            $('.payment-gateway-icon').not(this).prev().addClass('d-none');
            $('.form').addClass('d-none');
            if($this.data('title') == 'paypal' ){
                $('.paypal-form').removeClass('d-none');
            }else{
                $('.stripe-form').removeClass('d-none');
            }

        });

        $('.checkoutform').on('submit',function(e){
            $('#preloader').show();
        })


    </script>


</body>

</html>
<?php /**PATH /home/royaldem/public_html/project/resources/views/front/checkout.blade.php ENDPATH**/ ?>