<?php $__env->startSection('content'); ?>
<!--Main Breadcrumb Area Start -->
<div class="main-breadcrumb-area" style="background-image: url(<?php echo e($gs->breadcumb_banner ? asset('assets/images/'.$gs->breadcumb_banner):asset('assets/images/noimage.png')); ?>);">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <ul class="pages">
          <li>
            <a href="<?php echo e(route('front.index')); ?>">
              <?php echo e(__('Home')); ?>

            </a>
          </li>
          <?php if(!empty($cat)): ?>
          <li class="<?php echo e(empty($subcat) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('front.catalog',$cat->slug)); ?>">
              <?php echo e($cat->name); ?>

            </a>
          </li>
          <?php endif; ?>
          <?php if(!empty($subcat)): ?>
          <li class="active">
            <a href="<?php echo e(route('front.catalog', [$cat->slug, $subcat->slug])); ?>"><?php echo e($subcat->name); ?></a>
         </li>
          <?php endif; ?>
        </ul>
      </div>
    </div>
  </div>
</div>
<!--Main Breadcrumb Area End -->

<!-- Category Page Area Start -->
<section class="categories-page">
  <div class="container">
    <div class="row">

      <?php echo $__env->make('includes.catalog', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <div class="col-lg-9">
        <div class="all-products">
          <div class="row">
            <?php if(count($courses) > 0): ?>

            <div class="ajax-loader" style="background: url(<?php echo e(asset('assets/images/'.$gs->loader)); ?>) no-repeat scroll center center rgba(0,0,0,.6);"></div>

            <div class="col-lg-12" id="ajaxContent">

              <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div  class="single-course-long">
                <div class="img">
                  <img src="<?php echo e(asset('assets/images/courses/'.$course->photo)); ?>" alt="">
                </div>
                <div class="content">
                  <div class="left-area">
                    <p class="author">
                      <a href="<?php echo e(!empty($course->instructor) ? route('instructor.details',$course->instructor->instructor_slug) : route('instructor.details',DB::table('admins')->first()->slug)); ?>">
                        <?php echo e(!empty($course->instructor) ? $course->instructor->instructor_name : DB::table('admins')->first()->name); ?>

                      </a>
                    </p>
                  <h4 class="title">
                    <a href="<?php echo e(route('front.course',$course->slug)); ?>">
                      <?php echo e($course->title); ?>

                    </a>
                  </h4>
                  <a href="<?php echo e(route('front.course',$course->slug)); ?>" class="text">
                    <?php echo e($course->short_description); ?>

                  </a>
                  <?php if(App\Models\Rating::normalRating($course->id) != 0): ?>
                  <div class="reating-area">
                    <span class="number"><?php echo e(App\Models\Rating::normalRating($course->id)); ?></span>
                    <div class="stars">
                        <div class="ratings">
                            <div class="empty-stars"></div>
                            <div class="full-stars" style="width:<?php echo e(App\Models\Rating::ratings($course->id)); ?>%"></div>
                          </div>
                    </div>
                    <div class="total-star">
                      (<?php echo e(App\Models\Rating::ratingCount($course->id)); ?>)
                    </div>
                  </div>
                  <?php endif; ?>
                  <ul class="short-info">
                    <?php if($course->convertTime() != ''): ?>
                    <li>
                      <?php echo e($course->convertTime()); ?>

                    </li>
                    <?php endif; ?>
                    <li>
                      <?php echo e($course->sections()->withCount('lessons')->get()->sum('lessons_count')); ?> <?php echo e(__('lecture(s)')); ?>

                    </li>
                    <li>
                        <?php echo e($course->level); ?> <?php echo e(__('Level')); ?>

                    </li>
                  </ul>
                  </div>
                  <div class="right-area">
                    <?php if($course->price == 0): ?>

                    <p class="price">
                      <?php echo e(__('Free')); ?>

                    </p>

                    <?php else: ?>

                    <p class="price">
                      <?php echo e($curr->sign); ?><?php echo e(round(($course->price * $curr->value),2)); ?> <del><?php echo e($curr->sign); ?><?php echo e(round(($course->discount_price),2)); ?></del>
                    </p>

                    <?php endif; ?>
                  </div>

                </div>
              </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

              <div class="page-center mt-5">
                <?php echo $courses->appends(['search' => request()->input('search')])->links(); ?>

              </div>


            </div>
            <?php else: ?>
            <h4><?php echo e(__('Course Not Found')); ?></h4>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Category Page Area End -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>



    $("#sortby").on('change', function() {

    $("#preloader").show();
    filter();

    });

    $(".course-type").on('change', function() {

    if(this.checked){
        $('.course-type').not(this).prop('checked', false);
        $("#preloader").show();
        filter();
    }

    });


    $(".ratings").on('change', function() {

      $("#preloader").show();
        filter();

    });

    $(".durations").on('change', function() {

    if(this.checked){
        $('.durations').not(this).prop('checked', false);
        $("#preloader").show();
        filter();
    }

    });


    $(".course-level").on('change', function() {

    if(this.checked){
        $('.course-level').not(this).prop('checked', false);
        $("#preloader").show();
        filter();
    }

    });


  function filter() {
    let filterlink = '';

    if ($("#sortby").val() != '') {
      if (filterlink == '') {
        filterlink += '<?php echo e(route('front.catalog', [Request::route('category'), Request::route('subcategory')])); ?>' + '?'+$("#sortby").attr('name')+'='+$("#sortby").val();
      } else {
        filterlink += '&'+$("#sortby").attr('name')+'='+$("#sortby").val();
      }
    }

    $(".course-type").each(function() {
      if ($(this).is(':checked')) {
        if (filterlink == '') {
          filterlink += '<?php echo e(route('front.catalog', [Request::route('category'), Request::route('subcategory')])); ?>' + '?'+$(this).attr('name')+'='+$(this).val();
        } else {
          filterlink += '&'+$(this).attr('name')+'='+$(this).val();
        }
      }
    });


    $(".ratings").each(function() {
      if ($(this).is(':checked')) {
        if (filterlink == '') {
          filterlink += '<?php echo e(route('front.catalog', [Request::route('category'), Request::route('subcategory')])); ?>' + '?'+$(this).attr('name')+'='+$(this).val();
        } else {
          filterlink += '&'+$(this).attr('name')+'='+$(this).val();
        }
      }
    });


    $(".durations").each(function() {
      if ($(this).is(':checked')) {
        if (filterlink == '') {
          filterlink += '<?php echo e(route('front.catalog', [Request::route('category'), Request::route('subcategory')])); ?>' + '?'+$(this).attr('name')+'='+$(this).val();
        } else {
          filterlink += '&'+$(this).attr('name')+'='+$(this).val();
        }
      }
    });

    $(".course-level").each(function() {
      if ($(this).is(':checked')) {
        if (filterlink == '') {
          filterlink += '<?php echo e(route('front.catalog', [Request::route('category'), Request::route('subcategory')])); ?>' + '?'+$(this).attr('name')+'='+$(this).val();
        } else {
          filterlink += '&'+$(this).attr('name')+'='+$(this).val();
        }
      }
    });


    $("#ajaxContent").load(encodeURI(filterlink), function(data) {
      // add query string to pagination
      addToPagination();
      $("#preloader").fadeOut(1000);
    });
  }

  // append parameters to pagination links
  function addToPagination() {


    // add to attributes in pagination links
    $('ul.pagination li a').each(function() {
      let url = $(this).attr('href');
      let queryString = '?' + url.split('?')[1]; // "?page=1234...."

      let urlParams = new URLSearchParams(queryString);
      let page = urlParams.get('page'); // value of 'page' parameter

      let fullUrl = '<?php echo e(route('front.catalog', [Request::route('category'),Request::route('subcategory')])); ?>?page='+page+'&search='+'<?php echo e(urlencode(request()->input('search'))); ?>';


      if ($("#sortby").val() != '') {
        fullUrl += '&sort='+encodeURI($("#sortby").val());
      }

      $(".course-type").each(function() {
        if ($(this).is(':checked')) {
          fullUrl += '&'+encodeURI($(this).attr('name'))+'='+encodeURI($(this).val());
        }
      });

      $(".course-level").each(function() {
        if ($(this).is(':checked')) {
          fullUrl += '&'+encodeURI($(this).attr('name'))+'='+encodeURI($(this).val());
        }
      });

      $(".ratings").each(function() {
        if ($(this).is(':checked')) {
          fullUrl += '&'+encodeURI($(this).attr('name'))+'='+encodeURI($(this).val());
        }
      });

      $(".durations").each(function() {
        if ($(this).is(':checked')) {
          fullUrl += '&'+encodeURI($(this).attr('name'))+'='+encodeURI($(this).val());
        }
      });


      $(this).attr('href', fullUrl);

    });
  }

</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/royaldem/public_html/project/resources/views/front/catalog.blade.php ENDPATH**/ ?>